/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.log;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class TerseFormatter
extends Formatter {
    private static final String PREFIX = "";
    private static final String SUFFIX = " - ";
    private final String lineSeparator = System.getProperty("line.separator");
    private static final int FINE = 500;
    private static final int INFO = 800;
    private static final int WARNING = 900;
    private static final int SEVERE = 1000;
    private final StringBuilder buffer = new StringBuilder();
    private SimpleDateFormat timestampFormatter;

    public TerseFormatter() {
        this.buffer.append(PREFIX);
        this.timestampFormatter = new SimpleDateFormat("HH:mm:ss.SSS");
    }

    @Override
    public synchronized String format(LogRecord record) {
        this.buffer.setLength(PREFIX.length());
        this.buffer.append(this.timestampFormatter.format(new Date(record.getMillis())));
        this.buffer.append(' ');
        this.buffer.append(this.levelNumberToCommonsLevelName(record.getLevel()));
        String[] parts = record.getSourceClassName().split("\\.");
        this.buffer.append(" [" + parts[parts.length - 1] + "." + record.getSourceMethodName() + "]");
        this.buffer.append(SUFFIX);
        this.buffer.append(this.formatMessage(record)).append(this.lineSeparator);
        if (record.getThrown() != null) {
            StringWriter trace = new StringWriter();
            record.getThrown().printStackTrace(new PrintWriter(trace));
            this.buffer.append(trace);
        }
        return this.buffer.toString();
    }

    private String levelNumberToCommonsLevelName(Level level) {
        switch (level.intValue()) {
            case 500: {
                return "DEBUG";
            }
            case 800: {
                return "INFO";
            }
            case 900: {
                return "WARN";
            }
            case 1000: {
                return "ERROR";
            }
        }
        return level.getLocalizedName();
    }
}

