/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.log;

import java.util.Arrays;
import java.util.Enumeration;
import java.util.Objects;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.openqa.selenium.grid.config.Config;
import org.openqa.selenium.grid.log.FlushingHandler;
import org.openqa.selenium.grid.log.JsonFormatter;
import org.openqa.selenium.grid.log.TerseFormatter;
import org.openqa.selenium.remote.tracing.DistributedTracer;

public class LoggingOptions {
    private final Config config;

    public LoggingOptions(Config config) {
        this.config = Objects.requireNonNull(config);
    }

    public boolean isUsingStructuredLogging() {
        return this.config.getBool("logging", "structured-logs").orElse(false);
    }

    public boolean isUsingPlainLogs() {
        return this.config.getBool("logging", "plain-logs").orElse(true);
    }

    public DistributedTracer getTracer() {
        return DistributedTracer.builder().detect().build();
    }

    public void configureLogging() {
        FlushingHandler handler;
        Logger logger;
        if (!this.config.getBool("logging", "enable").orElse(true).booleanValue()) {
            return;
        }
        LogManager logManager = LogManager.getLogManager();
        Enumeration<String> names = logManager.getLoggerNames();
        while (names.hasMoreElements()) {
            logger = logManager.getLogger(names.nextElement());
            Arrays.stream(logger.getHandlers()).forEach(logger::removeHandler);
        }
        logger = logManager.getLogger("");
        if (this.isUsingPlainLogs()) {
            handler = new FlushingHandler(System.out);
            handler.setFormatter(new TerseFormatter());
            logger.addHandler(handler);
        }
        if (this.isUsingStructuredLogging()) {
            handler = new FlushingHandler(System.out);
            handler.setFormatter(new JsonFormatter());
            logger.addHandler(handler);
        }
    }
}

