/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.selenium;

import com.thoughtworks.selenium.DefaultSelenium;
import com.thoughtworks.selenium.ScreenshotListener;
import com.thoughtworks.selenium.SeleneseTestBase;
import com.thoughtworks.selenium.Selenium;
import java.io.File;
import java.lang.reflect.Method;
import org.testng.ITestContext;
import org.testng.ITestNGListener;
import org.testng.TestRunner;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeSuite;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Optional;
import org.testng.annotations.Parameters;

public class SeleneseTestNgHelper
extends SeleneseTestBase {
    private static Selenium staticSelenium;

    @Override
    @BeforeTest
    @Parameters(value={"selenium.url", "selenium.browser"})
    public void setUp(@Optional String url, @Optional String browserString) throws Exception {
        if (browserString == null) {
            browserString = this.runtimeBrowserString();
        }
        super.setUp(url, browserString);
        staticSelenium = this.selenium;
    }

    @BeforeClass
    @Parameters(value={"selenium.restartSession"})
    public void getSelenium(@Optional(value="false") boolean restartSession) {
        this.selenium = staticSelenium;
        if (restartSession) {
            this.selenium.stop();
            this.selenium.start();
        }
    }

    @BeforeMethod
    public void setTestContext(Method method) {
        this.selenium.setContext(method.getDeclaringClass().getSimpleName() + "." + method.getName());
    }

    @BeforeSuite
    @Parameters(value={"selenium.host", "selenium.port"})
    public void attachScreenshotListener(@Optional(value="localhost") String host, @Optional(value="4444") String port, ITestContext context) {
        if (!"localhost".equals(host)) {
            return;
        }
        DefaultSelenium screenshotTaker = new DefaultSelenium(host, Integer.parseInt(port), "", "");
        TestRunner tr = (TestRunner)context;
        File outputDirectory = new File(context.getOutputDirectory());
        tr.addListener((ITestNGListener)new ScreenshotListener(outputDirectory, screenshotTaker));
    }

    @Override
    @AfterMethod
    public void checkForVerificationErrors() {
        super.checkForVerificationErrors();
    }

    @AfterMethod(alwaysRun=true)
    public void selectDefaultWindow() {
        if (this.selenium != null) {
            this.selenium.selectWindow("null");
        }
    }

    @Override
    @AfterTest(alwaysRun=true)
    public void tearDown() throws Exception {
        super.tearDown();
    }

    public static void assertEquals(Object actual, Object expected) {
        SeleneseTestBase.assertEquals(expected, actual);
    }

    public static void assertEquals(String actual, String expected) {
        SeleneseTestBase.assertEquals(expected, actual);
    }

    public static void assertEquals(String actual, String[] expected) {
        SeleneseTestBase.assertEquals((Object)expected, (Object)actual);
    }

    public static void assertEquals(String[] actual, String[] expected) {
        SeleneseTestBase.assertEquals(expected, actual);
    }

    public static boolean seleniumEquals(Object actual, Object expected) {
        return SeleneseTestBase.seleniumEquals(expected, actual);
    }

    public static boolean seleniumEquals(String actual, String expected) {
        return SeleneseTestBase.seleniumEquals(expected, actual);
    }

    @Override
    public void verifyEquals(Object actual, Object expected) {
        super.verifyEquals(expected, actual);
    }

    @Override
    public void verifyEquals(String[] actual, String[] expected) {
        super.verifyEquals(expected, actual);
    }
}

