/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.json;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.openqa.selenium.json.JsonInput;
import org.openqa.selenium.json.JsonTypeCoercer;
import org.openqa.selenium.json.PropertySetting;
import org.openqa.selenium.json.TypeCoercer;

class MapCoercer<T, I extends T>
extends TypeCoercer<T> {
    private final Class<T> stereotype;
    private final JsonTypeCoercer coercer;
    private final Supplier<I> supplier;
    private final Function<I, BiConsumer<Object, Object>> consumerFactory;

    public MapCoercer(Class<T> stereotype, JsonTypeCoercer coercer, Supplier<I> supplier, Function<I, BiConsumer<Object, Object>> consumerFactory) {
        this.stereotype = stereotype;
        this.coercer = coercer;
        this.supplier = supplier;
        this.consumerFactory = consumerFactory;
    }

    @Override
    public boolean test(Class<?> type) {
        return this.stereotype.isAssignableFrom(type);
    }

    @Override
    public BiFunction<JsonInput, PropertySetting, T> apply(Type type) {
        Object valueType;
        Object keyType;
        if (type instanceof ParameterizedType) {
            Type[] typeArguments = ((ParameterizedType)type).getActualTypeArguments();
            keyType = typeArguments[0];
            valueType = typeArguments[1];
        } else if (type instanceof Class) {
            keyType = Object.class;
            valueType = Object.class;
        } else {
            throw new IllegalArgumentException("Unhandled type: " + String.valueOf(type.getClass()));
        }
        return (arg_0, arg_1) -> this.lambda$apply$0((Type)keyType, valueType, arg_0, arg_1);
    }

    private /* synthetic */ Object lambda$apply$0(Type keyType, Type valueType, JsonInput jsonInput, PropertySetting setting) {
        jsonInput.beginObject();
        I toReturn = this.supplier.get();
        BiConsumer<Object, Object> consumer = this.consumerFactory.apply(toReturn);
        boolean stringKey = String.class.equals((Object)keyType);
        while (jsonInput.hasNext()) {
            String key = stringKey ? jsonInput.nextName() : this.coercer.coerce(jsonInput, keyType, setting);
            Object value = this.coercer.coerce(jsonInput, valueType, setting);
            consumer.accept(key, value);
        }
        jsonInput.endObject();
        return toReturn;
    }
}

