/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.json;

import java.io.StringReader;
import java.lang.reflect.Type;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalAccessor;
import java.util.function.BiFunction;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.JsonException;
import org.openqa.selenium.json.JsonInput;
import org.openqa.selenium.json.JsonType;
import org.openqa.selenium.json.JsonTypeCoercer;
import org.openqa.selenium.json.PropertySetting;
import org.openqa.selenium.json.TypeCoercer;

public class InstantCoercer
extends TypeCoercer<Instant> {
    private final JsonTypeCoercer typeCoercer;

    InstantCoercer(JsonTypeCoercer typeCoercer) {
        this.typeCoercer = (JsonTypeCoercer)Require.nonNull((String)"TypeCoercer", (Object)typeCoercer);
    }

    @Override
    public boolean test(Class<?> aClass) {
        return Instant.class.isAssignableFrom(aClass);
    }

    @Override
    public BiFunction<JsonInput, PropertySetting, Instant> apply(Type type) {
        return (jsonInput, setting) -> {
            JsonType token = jsonInput.peek();
            switch (token) {
                case NUMBER: {
                    return Instant.ofEpochMilli(jsonInput.nextNumber().longValue());
                }
                case STRING: {
                    String raw = jsonInput.nextString();
                    try {
                        TemporalAccessor parsed = DateTimeFormatter.ISO_INSTANT.parse(raw);
                        return Instant.from(parsed);
                    }
                    catch (DateTimeParseException invalidDateTime) {
                        JsonException failure = new JsonException(String.format("\"%s\" does not look like an Instant", raw), invalidDateTime);
                        JsonInput nestedInput = new JsonInput(new StringReader(raw), this.typeCoercer, PropertySetting.BY_NAME);
                        try {
                            Number number = nestedInput.nextNumber();
                            nestedInput.nextEnd();
                            double doubleValue = number.doubleValue();
                            if (doubleValue % 1.0 != 0.0) {
                                throw new JsonException("unexpected decimal value");
                            }
                            if (doubleValue < -9.223372036854776E18 || doubleValue > 9.223372036854776E18) {
                                throw new JsonException("value out of range");
                            }
                            Instant instant = Instant.ofEpochMilli(number.longValue());
                            nestedInput.close();
                            return instant;
                        }
                        catch (Throwable throwable) {
                            try {
                                try {
                                    nestedInput.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                            catch (JsonException invalidLong) {
                                failure.addSuppressed((Throwable)((Object)new JsonException(String.format("\"%s\" is not a valid timestamp", raw), (Throwable)((Object)invalidLong))));
                                throw failure;
                            }
                        }
                    }
                }
            }
            throw new JsonException("Unable to parse: " + String.valueOf((Object)token) + " as Instant");
        };
    }
}

