/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.io;

import com.google.common.base.Preconditions;
import com.google.common.io.Closeables;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Base64;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.openqa.selenium.io.FileHandler;

public class Zip {
    private static final int BUF_SIZE = 16384;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zip(File inputDir, File output) throws IOException {
        if (output.exists()) {
            throw new IOException("File already exists: " + output);
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(output);
            this.zip(inputDir, fos);
        }
        finally {
            Closeables.close((Closeable)fos, (boolean)false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String zip(File inputDir) throws IOException {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            this.zip(inputDir, bos);
            String string = Base64.getEncoder().encodeToString(bos.toByteArray());
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String zipFile(File baseDir, File fileToCompress) throws IOException {
        Preconditions.checkArgument((boolean)fileToCompress.isFile(), (Object)("File should be a file: " + fileToCompress));
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ZipOutputStream zos = new ZipOutputStream(bos);
        try {
            this.addToZip(baseDir.getAbsolutePath(), zos, fileToCompress);
            String string = Base64.getEncoder().encodeToString(bos.toByteArray());
            return string;
        }
        finally {
            zos.close();
            bos.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zip(File inputDir, OutputStream writeTo) throws IOException {
        ZipOutputStream zos = null;
        try {
            zos = new ZipOutputStream(writeTo);
            this.addToZip(inputDir.getAbsolutePath(), zos, inputDir);
        }
        finally {
            Closeables.close((Closeable)zos, (boolean)false);
        }
    }

    private void addToZip(String basePath, ZipOutputStream zos, File toAdd) throws IOException {
        if (toAdd.isDirectory()) {
            File[] files = toAdd.listFiles();
            if (files != null) {
                for (File file : files) {
                    this.addToZip(basePath, zos, file);
                }
            }
        } else {
            int len;
            FileInputStream fis = new FileInputStream(toAdd);
            String name = toAdd.getAbsolutePath().substring(basePath.length() + 1);
            ZipEntry entry = new ZipEntry(name.replace('\\', '/'));
            zos.putNextEntry(entry);
            byte[] buffer = new byte[4096];
            while ((len = fis.read(buffer)) != -1) {
                zos.write(buffer, 0, len);
            }
            fis.close();
            zos.closeEntry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unzip(String source, File outputDir) throws IOException {
        byte[] bytes = Base64.getDecoder().decode(source);
        ByteArrayInputStream bis = null;
        try {
            bis = new ByteArrayInputStream(bytes);
            this.unzip(bis, outputDir);
        }
        finally {
            Closeables.close((Closeable)bis, (boolean)false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unzip(File source, File outputDir) throws IOException {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(source);
            this.unzip(fis, outputDir);
        }
        finally {
            Closeables.close((Closeable)fis, (boolean)false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unzip(InputStream source, File outputDir) throws IOException {
        try (ZipInputStream zis = new ZipInputStream(source);){
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                File file = new File(outputDir, entry.getName());
                if (entry.isDirectory()) {
                    FileHandler.createDir(file);
                    continue;
                }
                this.unzipFile(outputDir, zis, entry.getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unzipFile(File output, InputStream zipStream, String name) throws IOException {
        File toWrite = new File(output, name);
        if (!FileHandler.createDir(toWrite.getParentFile())) {
            throw new IOException("Cannot create parent director for: " + name);
        }
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(toWrite), 16384);){
            int read;
            byte[] buffer = new byte[16384];
            while ((read = zipStream.read(buffer)) != -1) {
                ((OutputStream)out).write(buffer, 0, read);
            }
        }
    }
}

