/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.http.jdk;

import com.google.auto.service.AutoService;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.Authenticator;
import java.net.ConnectException;
import java.net.PasswordAuthentication;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpResponse;
import java.net.http.HttpTimeoutException;
import java.net.http.WebSocket;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import org.openqa.selenium.Credentials;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.UsernameAndPassword;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.http.BinaryMessage;
import org.openqa.selenium.remote.http.ClientConfig;
import org.openqa.selenium.remote.http.CloseMessage;
import org.openqa.selenium.remote.http.ConnectionFailedException;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpClientName;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.http.Message;
import org.openqa.selenium.remote.http.TextMessage;
import org.openqa.selenium.remote.http.WebSocket;
import org.openqa.selenium.remote.http.jdk.ConnectionException;
import org.openqa.selenium.remote.http.jdk.JdkHttpMessages;

public class JdkHttpClient
implements HttpClient {
    public static final Logger LOG = Logger.getLogger(JdkHttpClient.class.getName());
    private static final AtomicInteger POOL_COUNTER = new AtomicInteger(0);
    private final JdkHttpMessages messages;
    private final HttpHandler handler;
    private java.net.http.HttpClient client;
    private final List<WebSocket> websockets;
    private final ExecutorService executorService;
    private final Duration readTimeout;
    private final Duration connectTimeout;

    JdkHttpClient(ClientConfig config) {
        String version;
        SSLContext sslContext;
        Objects.requireNonNull(config, "Client config must be set");
        this.messages = new JdkHttpMessages(config);
        this.readTimeout = config.readTimeout();
        this.connectTimeout = config.connectionTimeout();
        this.websockets = new ArrayList<WebSocket>();
        this.handler = config.filter().andFinally(this::execute0);
        String poolName = "JdkHttpClient-" + POOL_COUNTER.getAndIncrement();
        AtomicInteger threadCounter = new AtomicInteger(0);
        this.executorService = Executors.newCachedThreadPool(r -> {
            Thread thread = new Thread(r, poolName + "-" + threadCounter.getAndIncrement());
            thread.setDaemon(true);
            return thread;
        });
        HttpClient.Builder builder = java.net.http.HttpClient.newBuilder().connectTimeout(this.connectTimeout).followRedirects(HttpClient.Redirect.NEVER).executor(this.executorService);
        Credentials credentials = config.credentials();
        String info = config.baseUri().getUserInfo();
        if (info != null && !info.trim().isEmpty()) {
            String[] parts = info.split(":", 2);
            final String username = parts[0];
            final String password = parts.length > 1 ? parts[1] : null;
            Authenticator authenticator = new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(username, password.toCharArray());
                }
            };
            builder = builder.authenticator(authenticator);
        } else if (credentials != null) {
            if (!(credentials instanceof UsernameAndPassword)) {
                throw new IllegalArgumentException("Credentials must be a user name and password: " + String.valueOf(credentials));
            }
            final UsernameAndPassword uap = (UsernameAndPassword)credentials;
            Authenticator authenticator = new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(uap.username(), uap.password().toCharArray());
                }
            };
            builder = builder.authenticator(authenticator);
        }
        Proxy proxy = config.proxy();
        if (proxy != null) {
            HttpProxySelector proxySelector = new HttpProxySelector(proxy);
            builder = builder.proxy(proxySelector);
        }
        if ((sslContext = config.sslContext()) != null) {
            builder.sslContext(sslContext);
        }
        if ((version = config.version()) != null) {
            builder.version(HttpClient.Version.valueOf(version));
        }
        this.client = builder.build();
    }

    @Override
    public WebSocket openSocket(HttpRequest request, final WebSocket.Listener listener) {
        java.net.http.WebSocket underlyingSocket;
        URI uri;
        try {
            uri = this.getWebSocketUri(request);
        }
        catch (URISyntaxException e) {
            throw new ConnectionFailedException("JdkWebSocket initial request execution error", e);
        }
        WebSocket.Builder builder = this.client.newWebSocketBuilder();
        request.getHeaderNames().forEach(name -> builder.header((String)name, request.getHeader((String)name)));
        final CompletableFuture closed = new CompletableFuture();
        CompletableFuture<java.net.http.WebSocket> webSocketCompletableFuture = builder.connectTimeout(this.connectTimeout).buildAsync(uri, new WebSocket.Listener(){
            final StringBuilder builder = new StringBuilder();
            final ByteArrayOutputStream buffer = new ByteArrayOutputStream();

            @Override
            public CompletionStage<?> onText(java.net.http.WebSocket webSocket, CharSequence data, boolean last) {
                LOG.fine("Text message received. Appending data");
                this.builder.append(data);
                if (last) {
                    LOG.log(Level.FINE, "Final part of text message received. Calling listener with {0}", this.builder);
                    listener.onText(this.builder.toString());
                    this.builder.setLength(0);
                }
                webSocket.request(1L);
                return null;
            }

            @Override
            public CompletionStage<?> onBinary(java.net.http.WebSocket webSocket, ByteBuffer data, boolean last) {
                LOG.fine("Binary data received. Appending data");
                byte[] ary = new byte[8192];
                while (data.hasRemaining()) {
                    int n = Math.min(ary.length, data.remaining());
                    data.get(ary, 0, n);
                    this.buffer.write(ary, 0, n);
                }
                if (last) {
                    LOG.log(Level.FINE, "Final part of binary data received. Calling listener with {0} bytes of data", this.buffer.size());
                    listener.onBinary(this.buffer.toByteArray());
                    this.buffer.reset();
                }
                webSocket.request(1L);
                return null;
            }

            @Override
            public CompletionStage<?> onClose(java.net.http.WebSocket webSocket, int statusCode, String reason) {
                LOG.fine("Closing websocket");
                closed.complete(statusCode);
                listener.onClose(statusCode, reason);
                return null;
            }

            @Override
            public void onError(java.net.http.WebSocket webSocket, Throwable error) {
                LOG.log(Level.FINE, "An error has occurred: " + error.getMessage(), error);
                listener.onError(error);
            }
        });
        try {
            underlyingSocket = webSocketCompletableFuture.get(this.readTimeout.toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (CancellationException e) {
            throw new ConnectionFailedException("JdkWebSocket initial request canceled", e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            throw new ConnectionFailedException("JdkWebSocket initial request execution error", cause != null ? cause : e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ConnectionFailedException("JdkWebSocket initial request interrupted", e);
        }
        catch (java.util.concurrent.TimeoutException e) {
            webSocketCompletableFuture.cancel(true);
            throw new ConnectionFailedException("JdkWebSocket initial request timeout", e);
        }
        WebSocket websocket = new WebSocket(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public WebSocket send(Message message) {
                Supplier<CompletableFuture> makeCall;
                if (message instanceof BinaryMessage) {
                    BinaryMessage binaryMessage = (BinaryMessage)message;
                    LOG.fine("Sending binary message");
                    makeCall = () -> underlyingSocket.sendBinary(ByteBuffer.wrap(binaryMessage.data()), true);
                } else if (message instanceof TextMessage) {
                    TextMessage textMessage = (TextMessage)message;
                    LOG.log(Level.FINE, "Sending text message: {0}", textMessage.text());
                    makeCall = () -> underlyingSocket.sendText(textMessage.text(), true);
                } else {
                    if (!(message instanceof CloseMessage)) throw new IllegalArgumentException("Unsupported message type: " + String.valueOf(message));
                    CloseMessage closeMessage = (CloseMessage)message;
                    if (underlyingSocket.isOutputClosed()) {
                        LOG.fine("Output is closed, not sending close message");
                        return this;
                    }
                    int statusCode = closeMessage.code() == -1 ? 1000 : closeMessage.code();
                    LOG.log(Level.FINE, "Sending close message, statusCode {0}, reason: {1}", new Object[]{statusCode, closeMessage.reason()});
                    makeCall = () -> {
                        CompletableFuture<java.net.http.WebSocket> future = underlyingSocket.sendClose(statusCode, closeMessage.reason());
                        try {
                            closed.get(4L, TimeUnit.SECONDS);
                        }
                        catch (ExecutionException e) {
                            LOG.log(Level.WARNING, "failed to wait for the websocket to close", e.getCause());
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                        catch (java.util.concurrent.TimeoutException e) {
                            LOG.finer("wait for the websocket to close timed out");
                        }
                        return future;
                    };
                }
                java.net.http.WebSocket webSocket = underlyingSocket;
                synchronized (webSocket) {
                    long start = System.currentTimeMillis();
                    CompletableFuture future = makeCall.get();
                    try {
                        future.get(JdkHttpClient.this.readTimeout.toMillis(), TimeUnit.MILLISECONDS);
                    }
                    catch (CancellationException e) {
                        try {
                            throw new WebDriverException(e.getMessage(), (Throwable)e);
                            catch (ExecutionException e2) {
                                Throwable cause = e2.getCause();
                                if (cause != null) throw new WebDriverException(cause);
                                throw new WebDriverException((Throwable)e2);
                            }
                            catch (InterruptedException e3) {
                                Thread.currentThread().interrupt();
                                throw new WebDriverException(e3.getMessage());
                            }
                            catch (java.util.concurrent.TimeoutException e4) {
                                throw new TimeoutException((Throwable)e4);
                            }
                        }
                        catch (Throwable throwable) {
                            LOG.log(Level.FINE, "Websocket response to {0} read in {1}ms", new Object[]{message, System.currentTimeMillis() - start});
                            throw throwable;
                        }
                    }
                    LOG.log(Level.FINE, "Websocket response to {0} read in {1}ms", new Object[]{message, System.currentTimeMillis() - start});
                    return this;
                }
            }

            @Override
            public void close() {
                LOG.fine("Closing websocket");
                this.send(new CloseMessage(1000, "WebDriver closing socket"));
            }
        };
        this.websockets.add(websocket);
        return websocket;
    }

    private URI getWebSocketUri(HttpRequest request) throws URISyntaxException {
        URI uri = this.messages.getRawUri(request);
        if ("http".equalsIgnoreCase(uri.getScheme())) {
            uri = new URI("ws", uri.getUserInfo(), uri.getHost(), uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment());
        } else if ("https".equalsIgnoreCase(uri.getScheme())) {
            uri = new URI("wss", uri.getUserInfo(), uri.getHost(), uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment());
        }
        return uri;
    }

    @Override
    public CompletableFuture<HttpResponse> executeAsync(HttpRequest request) {
        CompletableFuture cf = new CompletableFuture();
        Future<?> future = this.executorService.submit(() -> {
            try {
                HttpResponse response = this.handler.execute(request);
                cf.complete(response);
            }
            catch (Throwable t) {
                cf.completeExceptionally(t);
            }
        });
        cf.whenComplete((result, throwable) -> {
            if (throwable instanceof CancellationException) {
                future.cancel(true);
            } else if (throwable instanceof java.util.concurrent.TimeoutException) {
                future.cancel(true);
            }
        });
        return cf.orTimeout(this.readTimeout.toMillis(), TimeUnit.MILLISECONDS);
    }

    @Override
    public HttpResponse execute(HttpRequest req) throws UncheckedIOException {
        CompletableFuture<HttpResponse> async = this.executeAsync(req);
        try {
            return (HttpResponse)async.get();
        }
        catch (CancellationException e) {
            throw new WebDriverException(e.getMessage(), (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            async.cancel(true);
            throw new WebDriverException(e.getMessage(), (Throwable)e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof java.util.concurrent.TimeoutException) {
                throw new TimeoutException(cause);
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw new WebDriverException(cause != null ? cause : e);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private HttpResponse execute0(HttpRequest req) throws UncheckedIOException {
        block14: {
            Objects.requireNonNull(req, "Request");
            JdkHttpClient.LOG.log(Level.FINE, "Executing request: {0}", req);
            start = System.currentTimeMillis();
            responseBodyHandler = HttpResponse.BodyHandlers.ofInputStream();
            rawUri = this.messages.getRawUri(req);
            method = req.getMethod();
            try {
                i = 0;
lbl10:
                // 2 sources

                while (i < 100) {
                    if (Thread.interrupted()) {
                        throw new InterruptedException(String.format("http request has been interrupted: %s", new Object[]{this.describe(req)}));
                    }
                    request = this.messages.createRequest(req, method, rawUri);
                    response = this.client.send(request, responseBodyHandler);
                    switch (response.statusCode()) {
                        case 303: {
                            method = HttpMethod.GET;
                        }
                        case 301: 
                        case 302: 
                        case 307: 
                        case 308: {
                            location = rawUri.resolve(this.getLocationHeader(response, method, rawUri));
                            this.checkNotDowngrade(rawUri, location);
                            rawUri = location;
                            ** break;
                        }
                    }
                    var11_14 = this.messages.createResponse(response);
                    break block14;
                }
                throw new ProtocolException(String.format("Too many redirects: 101 (%s)", new Object[]{this.describe(req)}));
            }
            catch (HttpTimeoutException e) {
                throw new TimeoutException(String.format("Timeout when executing request (%s)", new Object[]{this.describe(req)}), (Throwable)e);
            }
            catch (ConnectException e) {
                throw new ConnectionException(String.format("Connection error (%s)", new Object[]{this.describe(req)}), JdkHttpClient.maskUrlCredentials(rawUri), e);
            }
            catch (IOException e) {
                throw new UncheckedIOException(String.format("Failed to execute request (%s)", new Object[]{this.describe(req)}), e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new WebDriverException(String.format("%s when executing request (%s)", new Object[]{e.getMessage(), this.describe(req)}), (Throwable)e);
            }
            catch (Throwable var12_15) {
                JdkHttpClient.LOG.log(Level.FINE, "Ending request {0} in {1}ms", new Object[]{req, System.currentTimeMillis() - start});
                throw var12_15;
            }
        }
        JdkHttpClient.LOG.log(Level.FINE, "Ending request {0} in {1}ms", new Object[]{req, System.currentTimeMillis() - start});
        return var11_14;
lbl-1000:
        // 1 sources

        {
            ++i;
            ** GOTO lbl10
        }
    }

    private void checkNotDowngrade(URI from, URI to) {
        if (this.isDowngradeFrom("https", from, to) || this.isDowngradeFrom("wss", from, to)) {
            throw new SecurityException(String.format("Downgrade from secure to insecure connection (%s -> %s)", from, to));
        }
    }

    private boolean isDowngradeFrom(String protocol, URI from, URI to) {
        return protocol.equalsIgnoreCase(from.getScheme()) && !protocol.equalsIgnoreCase(to.getScheme());
    }

    private String describe(HttpRequest req) {
        String uri = JdkHttpClient.maskUrlCredentials(this.messages.getRawUri(req));
        HttpMethod method = req.getMethod();
        return String.format("%s %s", new Object[]{method, uri});
    }

    static String maskUrlCredentials(String uri) {
        try {
            return JdkHttpClient.maskUrlCredentials(new URI(uri));
        }
        catch (URISyntaxException invalidUri) {
            return uri;
        }
    }

    private static String maskUrlCredentials(URI u) {
        if (u.getUserInfo() == null) {
            return u.toString();
        }
        try {
            return new URI(u.getScheme(), "***", u.getHost(), u.getPort(), u.getPath(), u.getQuery(), u.getFragment()).toString();
        }
        catch (URISyntaxException e) {
            return u.toString();
        }
    }

    private String getLocationHeader(java.net.http.HttpResponse<InputStream> response, HttpMethod method, URI uri) throws ProtocolException {
        return response.headers().firstValue("location").orElseThrow(() -> {
            String message = String.format("HTTP response with status %d but without \"location\" header (%s %s)", new Object[]{response.statusCode(), method, JdkHttpClient.maskUrlCredentials(uri)});
            return new ProtocolException(message);
        });
    }

    @Override
    public <T> CompletableFuture<java.net.http.HttpResponse<T>> sendAsyncNative(java.net.http.HttpRequest request, HttpResponse.BodyHandler<T> handler) {
        return this.client.sendAsync(request, handler);
    }

    @Override
    public <T> java.net.http.HttpResponse<T> sendNative(java.net.http.HttpRequest request, HttpResponse.BodyHandler<T> handler) throws IOException, InterruptedException {
        return this.client.send(request, handler);
    }

    @Override
    public void close() {
        if (this.client == null) {
            return;
        }
        for (WebSocket websocket : this.websockets) {
            try {
                websocket.close();
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "failed to close the websocket: " + String.valueOf(websocket), e);
            }
        }
        if (this.client instanceof AutoCloseable) {
            AutoCloseable closeable = this.client;
            this.executorService.submit(() -> {
                try {
                    closeable.close();
                }
                catch (Exception e) {
                    LOG.log(Level.WARNING, "failed to close the http client: " + String.valueOf(closeable), e);
                }
            });
        }
        this.client = null;
        this.executorService.shutdown();
    }

    private static class HttpProxySelector
    extends ProxySelector {
        private final Proxy proxy;

        public HttpProxySelector(Proxy proxy) {
            this.proxy = proxy;
        }

        @Override
        public List<Proxy> select(URI uri) {
            if (this.proxy == null) {
                return List.of();
            }
            if (uri.getScheme().toLowerCase(Locale.ENGLISH).startsWith("http")) {
                return List.of(this.proxy);
            }
            return List.of();
        }

        @Override
        public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
        }
    }

    @HttpClientName(value="jdk-http-client")
    @AutoService(value={HttpClient.Factory.class})
    public static class Factory
    implements HttpClient.Factory {
        @Override
        public HttpClient createClient(ClientConfig config) {
            Objects.requireNonNull(config, "Client config must be set");
            return new JdkHttpClient(config);
        }
    }
}

