/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.http.jdk;

import com.google.common.net.MediaType;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpRequest;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.openqa.selenium.remote.http.AddSeleniumUserAgent;
import org.openqa.selenium.remote.http.ClientConfig;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpHeader;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;

class JdkHttpMessages {
    private final ClientConfig config;
    private static final List<String> IGNORE_HEADERS = List.of("content-length", "connection", "host");

    public JdkHttpMessages(ClientConfig config) {
        this.config = Objects.requireNonNull(config, "Client config");
    }

    public java.net.http.HttpRequest createRequest(HttpRequest req, HttpMethod method, URI rawUri) {
        Object rawUrl = rawUri.toString();
        String queryString = StreamSupport.stream(req.getQueryParameterNames().spliterator(), false).map(name -> StreamSupport.stream(req.getQueryParameters((String)name).spliterator(), false).map(value -> String.format("%s=%s", URLEncoder.encode(name, StandardCharsets.UTF_8), URLEncoder.encode(value, StandardCharsets.UTF_8))).collect(Collectors.joining("&"))).collect(Collectors.joining("&"));
        if (!queryString.isEmpty()) {
            rawUrl = (String)rawUrl + "?" + queryString;
        }
        HttpRequest.Builder builder = java.net.http.HttpRequest.newBuilder().uri(URI.create((String)rawUrl));
        switch (method) {
            case DELETE: {
                builder.DELETE();
                break;
            }
            case GET: {
                builder.GET();
                break;
            }
            case POST: {
                builder.POST(this.notChunkingBodyPublisher(req));
                break;
            }
            case PUT: {
                builder.PUT(this.notChunkingBodyPublisher(req));
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unsupported request method %s: %s", new Object[]{req.getMethod(), req}));
            }
        }
        req.forEachHeader((name, value) -> {
            if (IGNORE_HEADERS.contains(name.toLowerCase(Locale.ENGLISH))) {
                return;
            }
            builder.header((String)name, (String)value);
        });
        if (req.getHeader(HttpHeader.UserAgent) == null) {
            builder.header(HttpHeader.UserAgent.getName(), AddSeleniumUserAgent.USER_AGENT);
        }
        builder.timeout(this.config.readTimeout());
        return builder.build();
    }

    private HttpRequest.BodyPublisher notChunkingBodyPublisher(HttpRequest req) {
        Contents.Supplier content = req.getContent();
        if (content.length() > 0L) {
            HttpRequest.BodyPublisher chunking = HttpRequest.BodyPublishers.ofInputStream(content);
            return HttpRequest.BodyPublishers.fromPublisher(chunking, content.length());
        }
        return HttpRequest.BodyPublishers.noBody();
    }

    public URI getRawUri(HttpRequest req) {
        String base;
        URI baseUrl = this.config.baseUri();
        String uri = req.getUri();
        Object rawUrl = uri.startsWith("ws://") || uri.startsWith("wss://") || uri.startsWith("http://") || uri.startsWith("https://") ? uri : ((base = baseUrl.toString()).endsWith("/") ? base.substring(0, base.length() - 1) + uri : base + uri);
        return URI.create((String)rawUrl);
    }

    public HttpResponse createResponse(java.net.http.HttpResponse<InputStream> response) {
        HttpResponse res = new HttpResponse();
        res.setStatus(response.statusCode());
        this.copyHeaders(response, res);
        res.setContent(this.extractContent(response));
        return res;
    }

    private void copyHeaders(java.net.http.HttpResponse<?> from, HttpResponse to) {
        from.headers().map().forEach((name, values) -> values.stream().filter(Objects::nonNull).forEach(value -> to.addHeader((String)name, (String)value)));
    }

    private Contents.Supplier extractContent(java.net.http.HttpResponse<InputStream> response) {
        boolean isBinaryStream = response.headers().firstValue("Content-Type").map(contentType -> contentType.equalsIgnoreCase(MediaType.OCTET_STREAM.toString())).orElse(false);
        if (isBinaryStream) {
            long length = response.headers().firstValueAsLong("Content-Length").orElse(-1L);
            return Contents.fromStream(response.body(), length);
        }
        byte[] responseBody = this.readResponseBody(response);
        return responseBody.length > 0 ? Contents.bytes(responseBody) : Contents.empty();
    }

    private byte[] readResponseBody(java.net.http.HttpResponse<InputStream> response) {
        byte[] byArray;
        block8: {
            InputStream in = response.body();
            try {
                byArray = in.readAllBytes();
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            in.close();
        }
        return byArray;
    }
}

