/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.http;

import java.io.Closeable;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openqa.selenium.remote.http.BinaryMessage;
import org.openqa.selenium.remote.http.CloseMessage;
import org.openqa.selenium.remote.http.Message;
import org.openqa.selenium.remote.http.TextMessage;

public interface WebSocket
extends Closeable {
    public static final Logger LOG = Logger.getLogger(WebSocket.class.getName());

    public WebSocket send(Message var1);

    default public WebSocket sendText(CharSequence data) {
        return this.send(new TextMessage(data));
    }

    default public WebSocket sendBinary(byte[] data) {
        return this.send(new BinaryMessage(data));
    }

    @Override
    public void close();

    public static interface Listener
    extends Consumer<Message> {
        @Override
        default public void accept(Message message) {
            if (message instanceof BinaryMessage) {
                this.onBinary(((BinaryMessage)message).data());
            } else if (message instanceof CloseMessage) {
                this.onClose(((CloseMessage)message).code(), ((CloseMessage)message).reason());
            } else if (message instanceof TextMessage) {
                this.onText(((TextMessage)message).text());
            }
        }

        default public void onBinary(byte[] data) {
        }

        default public void onClose(int code, String reason) {
        }

        default public void onText(CharSequence data) {
        }

        default public void onError(Throwable cause) {
            LOG.log(Level.WARNING, cause.getMessage(), cause);
        }
    }
}

