/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.netty.server;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.ErrorFilter;
import org.openqa.selenium.remote.http.Filter;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;

class SeleniumHandler
extends SimpleChannelInboundHandler<HttpRequest> {
    private static final ExecutorService EXECUTOR = Executors.newCachedThreadPool();
    private final HttpHandler seleniumHandler;
    private Future<?> lastOne;

    public SeleniumHandler(HttpHandler seleniumHandler) {
        super(HttpRequest.class);
        this.seleniumHandler = ((HttpHandler)Require.nonNull((String)"HTTP handler", (Object)seleniumHandler)).with((Filter)new ErrorFilter());
        this.lastOne = CompletableFuture.completedFuture(null);
    }

    protected void channelRead0(ChannelHandlerContext ctx, HttpRequest msg) {
        this.lastOne = EXECUTOR.submit(() -> {
            HttpResponse res = this.seleniumHandler.execute(msg);
            ctx.writeAndFlush((Object)res);
        });
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.lastOne.cancel(true);
        super.channelInactive(ctx);
    }
}

