/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.sessionqueue;

import com.google.common.collect.ImmutableMap;
import org.openqa.selenium.grid.sessionqueue.NewSessionQueue;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.tracing.HttpTracing;
import org.openqa.selenium.remote.tracing.Span;
import org.openqa.selenium.remote.tracing.Tags;
import org.openqa.selenium.remote.tracing.Tracer;

public class ClearSessionQueue
implements HttpHandler {
    private final Tracer tracer;
    private final NewSessionQueue newSessionQueue;

    ClearSessionQueue(Tracer tracer, NewSessionQueue newSessionQueue) {
        this.tracer = (Tracer)Require.nonNull((String)"Tracer", (Object)tracer);
        this.newSessionQueue = (NewSessionQueue)Require.nonNull((String)"New Session Queue", (Object)newSessionQueue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpResponse execute(HttpRequest req) {
        Tags.HTTP_REQUEST.accept(span, req);
        try (Span span = HttpTracing.newSpanAsChildOf((Tracer)this.tracer, (HttpRequest)req, (String)"sessionqueue.clear");){
            int value = this.newSessionQueue.clearQueue();
            span.setAttribute("cleared", (Number)value);
            HttpResponse response = new HttpResponse();
            if (value != 0) {
                response.setContent(Contents.asJson((Object)ImmutableMap.of((Object)"value", (Object)value, (Object)"message", (Object)"Cleared the new session request queue", (Object)"cleared_requests", (Object)value)));
            } else {
                response.setContent(Contents.asJson((Object)ImmutableMap.of((Object)"value", (Object)value, (Object)"message", (Object)"New session request queue empty. Nothing to clear.")));
            }
            span.setAttribute("requests.cleared", (Number)value);
            Tags.HTTP_RESPONSE.accept(span, response);
            HttpResponse httpResponse = response;
            return httpResponse;
        }
    }
}

