/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.config;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedSet;
import io.ous.jtoml.JToml;
import io.ous.jtoml.ParseException;
import io.ous.jtoml.Toml;
import io.ous.jtoml.TomlTable;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Logger;
import org.openqa.selenium.grid.config.Config;
import org.openqa.selenium.grid.config.ConfigException;
import org.openqa.selenium.internal.Require;

public class TomlConfig
implements Config {
    private final Toml toml;
    private static final Logger LOG = Logger.getLogger(TomlConfig.class.getName());

    public TomlConfig(Reader reader) {
        try {
            this.toml = JToml.parse((Reader)reader);
            LOG.warning("Please use quotes to denote strings. Upcoming TOML parser will require this and unquoted strings will throw an error in the future");
        }
        catch (IOException e) {
            throw new ConfigException("Unable to read TOML.", new Object[]{e});
        }
        catch (ParseException e) {
            throw new ConfigException(String.valueOf(e.getCause()) + "\n Validate the config using https://www.toml-lint.com/. \n Refer to https://toml.io/en/ for TOML usage guidance. ", new Object[0]);
        }
    }

    public static Config from(Path path) {
        TomlConfig tomlConfig;
        block8: {
            Require.nonNull((String)"Path to read", (Object)path);
            BufferedReader reader = Files.newBufferedReader(path);
            try {
                tomlConfig = new TomlConfig(reader);
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ConfigException(String.format("Unable to parse: %s", path), new Object[]{e});
                }
            }
            ((Reader)reader).close();
        }
        return tomlConfig;
    }

    @Override
    public Optional<List<String>> getAll(String section, String option) {
        Require.nonNull((String)"Section to read", (Object)section);
        Require.nonNull((String)"Option to read", (Object)option);
        if (!this.toml.containsKey((Object)section)) {
            return Optional.empty();
        }
        Object raw = this.toml.get((Object)section);
        if (!(raw instanceof TomlTable)) {
            throw new ConfigException(String.format("Section %s is not a section! %s", section, raw), new Object[0]);
        }
        TomlTable table = this.toml.getTomlTable(section, new Object[0]);
        Object value = table.getOrDefault((Object)option, null);
        if (value == null) {
            return Optional.empty();
        }
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            if (collection.stream().anyMatch(item -> item instanceof TomlTable)) {
                return Optional.of((List)collection.stream().map(item -> (TomlTable)item).map(TomlTable::toMap).map(this::toEntryList).flatMap(Collection::stream).collect(ImmutableList.toImmutableList()));
            }
            return Optional.of((List)collection.stream().filter(item -> !(item instanceof Collection)).map(String::valueOf).collect(ImmutableList.toImmutableList()));
        }
        if (value instanceof TomlTable) {
            return Optional.of(this.toEntryList(((TomlTable)value).toMap()));
        }
        return Optional.of(ImmutableList.of((Object)String.valueOf(value)));
    }

    @Override
    public Set<String> getSectionNames() {
        return ImmutableSortedSet.copyOf((Collection)this.toml.keySet());
    }

    @Override
    public Set<String> getOptions(String section) {
        Require.nonNull((String)"Section name to get options for", (Object)section);
        Object raw = this.toml.get((Object)section);
        if (!(raw instanceof TomlTable)) {
            return ImmutableSortedSet.of();
        }
        return ImmutableSortedSet.copyOf((Collection)((TomlTable)raw).keySet());
    }
}

