/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.node.docker;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.ImmutableCapabilities;
import org.openqa.selenium.PersistentCapabilities;
import org.openqa.selenium.RetrySessionRequestException;
import org.openqa.selenium.SessionNotCreatedException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.docker.Container;
import org.openqa.selenium.docker.ContainerConfig;
import org.openqa.selenium.docker.ContainerInfo;
import org.openqa.selenium.docker.Device;
import org.openqa.selenium.docker.Docker;
import org.openqa.selenium.docker.Image;
import org.openqa.selenium.docker.Port;
import org.openqa.selenium.grid.data.CreateSessionRequest;
import org.openqa.selenium.grid.data.DefaultSlotMatcher;
import org.openqa.selenium.grid.data.SlotMatcher;
import org.openqa.selenium.grid.node.ActiveSession;
import org.openqa.selenium.grid.node.SessionFactory;
import org.openqa.selenium.grid.node.docker.DockerAssetsPath;
import org.openqa.selenium.grid.node.docker.DockerSession;
import org.openqa.selenium.internal.Either;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.net.PortProber;
import org.openqa.selenium.remote.Command;
import org.openqa.selenium.remote.Dialect;
import org.openqa.selenium.remote.DriverCommand;
import org.openqa.selenium.remote.ProtocolHandshake;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.http.ClientConfig;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpMessage;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.tracing.AttributeKey;
import org.openqa.selenium.remote.tracing.EventAttribute;
import org.openqa.selenium.remote.tracing.EventAttributeValue;
import org.openqa.selenium.remote.tracing.Span;
import org.openqa.selenium.remote.tracing.Status;
import org.openqa.selenium.remote.tracing.Tags;
import org.openqa.selenium.remote.tracing.Tracer;
import org.openqa.selenium.support.ui.FluentWait;

public class DockerSessionFactory
implements SessionFactory {
    private static final Logger LOG = Logger.getLogger(DockerSessionFactory.class.getName());
    private final Tracer tracer;
    private final HttpClient.Factory clientFactory;
    private final Duration sessionTimeout;
    private final Docker docker;
    private final URI dockerUri;
    private final Image browserImage;
    private final Capabilities stereotype;
    private final List<Device> devices;
    private final Image videoImage;
    private final DockerAssetsPath assetsPath;
    private final String networkName;
    private final boolean runningInDocker;
    private final SlotMatcher slotMatcher;

    public DockerSessionFactory(Tracer tracer, HttpClient.Factory clientFactory, Duration sessionTimeout, Docker docker, URI dockerUri, Image browserImage, Capabilities stereotype, List<Device> devices, Image videoImage, DockerAssetsPath assetsPath, String networkName, boolean runningInDocker) {
        this.tracer = (Tracer)Require.nonNull((String)"Tracer", (Object)tracer);
        this.clientFactory = (HttpClient.Factory)Require.nonNull((String)"HTTP client", (Object)clientFactory);
        this.sessionTimeout = (Duration)Require.nonNull((String)"Session timeout", (Object)sessionTimeout);
        this.docker = (Docker)Require.nonNull((String)"Docker command", (Object)docker);
        this.dockerUri = (URI)Require.nonNull((String)"Docker URI", (Object)dockerUri);
        this.browserImage = (Image)Require.nonNull((String)"Docker browser image", (Object)browserImage);
        this.networkName = (String)Require.nonNull((String)"Docker network name", (Object)networkName);
        this.stereotype = ImmutableCapabilities.copyOf((Capabilities)((Capabilities)Require.nonNull((String)"Stereotype", (Object)stereotype)));
        this.devices = (List)Require.nonNull((String)"Container devices", devices);
        this.videoImage = videoImage;
        this.assetsPath = assetsPath;
        this.runningInDocker = runningInDocker;
        this.slotMatcher = new DefaultSlotMatcher();
    }

    @Override
    public boolean test(Capabilities capabilities) {
        return this.slotMatcher.matches(this.stereotype, capabilities);
    }

    @Override
    public Either<WebDriverException, ActiveSession> apply(CreateSessionRequest sessionRequest) {
        LOG.info("Starting session for " + sessionRequest.getDesiredCapabilities());
        int port = this.runningInDocker ? 4444 : PortProber.findFreePort();
        Span span = this.tracer.getCurrentContext().createSpan("docker_session_factory.apply");
        try {
            Response response;
            ProtocolHandshake.Result result;
            HashMap<String, EventAttributeValue> attributeMap = new HashMap<String, EventAttributeValue>();
            attributeMap.put(AttributeKey.LOGGER_CLASS.getKey(), EventAttribute.setValue((String)this.getClass().getName()));
            String logMessage = this.runningInDocker ? "Creating container..." : "Creating container, mapping container port 4444 to " + port;
            LOG.info(logMessage);
            Container container = this.createBrowserContainer(port, sessionRequest.getDesiredCapabilities());
            container.start();
            ContainerInfo containerInfo = container.inspect();
            String containerIp = containerInfo.getIp();
            URL remoteAddress = this.getUrl(port, containerIp);
            ClientConfig clientConfig = ClientConfig.defaultConfig().baseUrl(remoteAddress).readTimeout(this.sessionTimeout);
            HttpClient client = this.clientFactory.createClient(clientConfig);
            attributeMap.put("docker.browser.image", EventAttribute.setValue((String)this.browserImage.toString()));
            attributeMap.put("container.port", EventAttribute.setValue((long)port));
            attributeMap.put("container.id", EventAttribute.setValue((String)container.getId().toString()));
            attributeMap.put("container.ip", EventAttribute.setValue((String)containerIp));
            attributeMap.put("docker.server.url", EventAttribute.setValue((String)remoteAddress.toString()));
            LOG.info(String.format("Waiting for server to start (container id: %s, url %s)", container.getId(), remoteAddress));
            try {
                this.waitForServerToStart(client, Duration.ofMinutes(1L));
            }
            catch (TimeoutException e) {
                span.setAttribute("error", true);
                span.setStatus(Status.CANCELLED);
                Tags.EXCEPTION.accept(attributeMap, e);
                attributeMap.put(AttributeKey.EXCEPTION_MESSAGE.getKey(), EventAttribute.setValue((String)("Unable to connect to docker server. Stopping container: " + e.getMessage())));
                span.addEvent(AttributeKey.EXCEPTION_EVENT.getKey(), attributeMap);
                container.stop(Duration.ofMinutes(1L));
                String message = String.format("Unable to connect to docker server (container id: %s)", container.getId());
                LOG.warning(message);
                Either either = Either.left((Object)new RetrySessionRequestException(message));
                if (span != null) {
                    span.close();
                }
                return either;
            }
            LOG.info(String.format("Server is ready (container id: %s)", container.getId()));
            Command command = new Command(null, DriverCommand.NEW_SESSION((Capabilities)sessionRequest.getDesiredCapabilities()));
            try {
                result = new ProtocolHandshake().createSession((HttpHandler)client, command);
                response = result.createResponse();
                attributeMap.put(AttributeKey.DRIVER_RESPONSE.getKey(), EventAttribute.setValue((String)response.toString()));
            }
            catch (IOException | RuntimeException e) {
                span.setAttribute("error", true);
                span.setStatus(Status.CANCELLED);
                Tags.EXCEPTION.accept(attributeMap, e);
                attributeMap.put(AttributeKey.EXCEPTION_MESSAGE.getKey(), EventAttribute.setValue((String)("Unable to create session. Stopping and  container: " + e.getMessage())));
                span.addEvent(AttributeKey.EXCEPTION_EVENT.getKey(), attributeMap);
                container.stop(Duration.ofMinutes(1L));
                String message = "Unable to create session: " + e.getMessage();
                LOG.log(Level.WARNING, message, e);
                Either either = Either.left((Object)((Object)new SessionNotCreatedException(message)));
                if (span != null) {
                    span.close();
                }
                return either;
            }
            SessionId id = new SessionId(response.getSessionId());
            ImmutableCapabilities capabilities = new ImmutableCapabilities((Map)response.getValue());
            Capabilities mergedCapabilities = sessionRequest.getDesiredCapabilities().merge((Capabilities)capabilities);
            mergedCapabilities = this.addForwardCdpEndpoint(mergedCapabilities, containerIp, port, id.toString());
            Container videoContainer = null;
            Optional<DockerAssetsPath> path = Optional.ofNullable(this.assetsPath);
            if (path.isPresent()) {
                String containerPath = path.get().getContainerPath(id);
                this.saveSessionCapabilities(mergedCapabilities, containerPath);
                String hostPath = path.get().getHostPath(id);
                videoContainer = this.startVideoContainer(mergedCapabilities, containerIp, hostPath);
            }
            Dialect downstream = sessionRequest.getDownstreamDialects().contains(result.getDialect()) ? result.getDialect() : Dialect.W3C;
            attributeMap.put(AttributeKey.DOWNSTREAM_DIALECT.getKey(), EventAttribute.setValue((String)downstream.toString()));
            attributeMap.put(AttributeKey.DRIVER_RESPONSE.getKey(), EventAttribute.setValue((String)response.toString()));
            span.addEvent("Docker driver service created session", attributeMap);
            LOG.fine(String.format("Created session: %s - %s (container id: %s)", id, mergedCapabilities, container.getId()));
            Either either = Either.right((Object)new DockerSession(container, videoContainer, this.tracer, client, id, remoteAddress, this.stereotype, mergedCapabilities, downstream, result.getDialect(), Instant.now()));
            return either;
        }
        finally {
            if (span != null) {
                try {
                    span.close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    throwable2.addSuppressed(throwable);
                }
            }
        }
    }

    private Capabilities addForwardCdpEndpoint(Capabilities sessionCapabilities, String containerIp, int port, String sessionId) {
        String forwardCdpPath = String.format("ws://%s:%s/session/%s/se/fwd", containerIp, port, sessionId);
        return new PersistentCapabilities(sessionCapabilities).setCapability("se:forwardCdp", (Object)forwardCdpPath);
    }

    private Container createBrowserContainer(int port, Capabilities sessionCapabilities) {
        Map<String, String> browserContainerEnvVars = this.getBrowserContainerEnvVars(sessionCapabilities);
        long browserContainerShmMemorySize = 0x80000000L;
        ContainerConfig containerConfig = ContainerConfig.image(this.browserImage).env(browserContainerEnvVars).shmMemorySize(browserContainerShmMemorySize).network(this.networkName).devices(this.devices);
        if (!this.runningInDocker) {
            containerConfig = containerConfig.map(Port.tcp(4444), Port.tcp(port));
        }
        return this.docker.create(containerConfig);
    }

    private Map<String, String> getBrowserContainerEnvVars(Capabilities sessionRequestCapabilities) {
        Optional<Dimension> screenResolution = Optional.ofNullable(this.getScreenResolution(sessionRequestCapabilities));
        HashMap<String, String> envVars = new HashMap<String, String>();
        if (screenResolution.isPresent()) {
            envVars.put("SCREEN_WIDTH", String.valueOf(screenResolution.get().getWidth()));
            envVars.put("SCREEN_HEIGHT", String.valueOf(screenResolution.get().getHeight()));
        }
        Optional<TimeZone> timeZone = Optional.ofNullable(this.getTimeZone(sessionRequestCapabilities));
        timeZone.ifPresent(zone -> envVars.put("TZ", zone.getID()));
        return envVars;
    }

    private Container startVideoContainer(Capabilities sessionCapabilities, String browserContainerIp, String hostPath) {
        if (!this.recordVideoForSession(sessionCapabilities)) {
            return null;
        }
        int videoPort = 9000;
        Map<String, String> envVars = this.getVideoContainerEnvVars(sessionCapabilities, browserContainerIp);
        Map<String, String> volumeBinds = Collections.singletonMap(hostPath, "/videos");
        ContainerConfig containerConfig = ContainerConfig.image(this.videoImage).env(envVars).bind(volumeBinds).network(this.networkName);
        if (!this.runningInDocker) {
            videoPort = PortProber.findFreePort();
            containerConfig = containerConfig.map(Port.tcp(9000), Port.tcp(videoPort));
        }
        Container videoContainer = this.docker.create(containerConfig);
        videoContainer.start();
        String videoContainerIp = this.runningInDocker ? videoContainer.inspect().getIp() : "localhost";
        try {
            URL videoContainerUrl = new URL(String.format("http://%s:%s", videoContainerIp, videoPort));
            HttpClient videoClient = this.clientFactory.createClient(videoContainerUrl);
            LOG.fine(String.format("Waiting for video recording... (id: %s)", videoContainer.getId()));
            this.waitForServerToStart(videoClient, Duration.ofMinutes(1L));
        }
        catch (Exception e) {
            videoContainer.stop(Duration.ofSeconds(10L));
            String message = String.format("Unable to verify video recording started (container id: %s), %s", videoContainer.getId(), e.getMessage());
            LOG.warning(message);
        }
        LOG.info(String.format("Video container started (id: %s)", videoContainer.getId()));
        return videoContainer;
    }

    private Map<String, String> getVideoContainerEnvVars(Capabilities sessionRequestCapabilities, String containerIp) {
        HashMap<String, String> envVars = new HashMap<String, String>();
        envVars.put("DISPLAY_CONTAINER_NAME", containerIp);
        Optional<Dimension> screenResolution = Optional.ofNullable(this.getScreenResolution(sessionRequestCapabilities));
        screenResolution.ifPresent(dimension -> envVars.put("VIDEO_SIZE", String.format("%sx%s", dimension.getWidth(), dimension.getHeight())));
        return envVars;
    }

    private TimeZone getTimeZone(Capabilities sessionRequestCapabilities) {
        Optional<Object> timeZone = Optional.ofNullable(sessionRequestCapabilities.getCapability("se:timeZone"));
        if (timeZone.isPresent()) {
            String tz = timeZone.get().toString();
            if (Arrays.asList(TimeZone.getAvailableIDs()).contains(tz)) {
                return TimeZone.getTimeZone(tz);
            }
        }
        return null;
    }

    private Dimension getScreenResolution(Capabilities sessionRequestCapabilities) {
        Optional<Object> screenResolution = Optional.ofNullable(sessionRequestCapabilities.getCapability("se:screenResolution"));
        if (!screenResolution.isPresent()) {
            return null;
        }
        try {
            String[] resolution = screenResolution.get().toString().split("x");
            int screenWidth = Integer.parseInt(resolution[0]);
            int screenHeight = Integer.parseInt(resolution[1]);
            if (screenWidth > 0 && screenHeight > 0) {
                return new Dimension(screenWidth, screenHeight);
            }
            LOG.warning("One of the values provided for screenResolution is negative, defaults will be used. Received value: " + screenResolution);
        }
        catch (Exception e) {
            LOG.warning("Values provided for screenResolution are not valid integers or either width or height are missing, defaults will be used.Received value: " + screenResolution);
        }
        return null;
    }

    private boolean recordVideoForSession(Capabilities sessionRequestCapabilities) {
        Optional<Object> recordVideo = Optional.ofNullable(sessionRequestCapabilities.getCapability("se:recordVideo"));
        return recordVideo.isPresent() && Boolean.parseBoolean(recordVideo.get().toString());
    }

    private void saveSessionCapabilities(Capabilities sessionRequestCapabilities, String path) {
        String capsToJson = new Json().toJson((Object)sessionRequestCapabilities);
        try {
            Files.createDirectories(Paths.get(path, new String[0]), new FileAttribute[0]);
            Files.write(Paths.get(path, "sessionCapabilities.json"), capsToJson.getBytes(Charset.defaultCharset()), new OpenOption[0]);
        }
        catch (IOException e) {
            LOG.log(Level.WARNING, "Failed to save session capabilities", e);
        }
    }

    private void waitForServerToStart(HttpClient client, Duration duration) {
        FluentWait wait = new FluentWait(new Object()).withTimeout(duration).ignoring(UncheckedIOException.class);
        wait.until(obj -> {
            HttpResponse response = client.execute(new HttpRequest(HttpMethod.GET, "/status"));
            LOG.fine(Contents.string((HttpMessage)response));
            return 200 == response.getStatus();
        });
    }

    private URL getUrl(int port, String containerIp) {
        try {
            String host = "localhost";
            if (this.runningInDocker) {
                host = containerIp;
            } else if (this.dockerUri.getScheme().startsWith("tcp") || this.dockerUri.getScheme().startsWith("http")) {
                host = this.dockerUri.getHost();
            }
            return new URL(String.format("http://%s:%s/wd/hub", host, port));
        }
        catch (MalformedURLException e) {
            throw new SessionNotCreatedException(e.getMessage(), (Throwable)e);
        }
    }
}

