/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.security;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.Base64;
import java.util.Optional;
import org.openqa.selenium.UsernameAndPassword;
import org.openqa.selenium.grid.config.Config;
import org.openqa.selenium.grid.config.ConfigException;
import org.openqa.selenium.grid.security.Secret;

public class SecretOptions {
    private static final String ROUTER_SECTION = "router";
    private static final String SERVER_SECTION = "server";
    private final Config config;

    public SecretOptions(Config config) {
        this.config = config;
    }

    public Secret getRegistrationSecret() {
        String secret = "";
        if ((this.isSecure() || this.isSelfSigned()) && !this.config.get(SERVER_SECTION, "registration-secret").isPresent()) {
            try {
                secret = Base64.getEncoder().encodeToString(Arrays.copyOfRange(Files.readAllBytes(this.getCertificate().toPath()), 0, 32));
                return new Secret(secret);
            }
            catch (IOException e) {
                throw new ConfigException("Cannot read the certificate file: " + e.getMessage(), new Object[0]);
            }
        }
        return this.config.get(SERVER_SECTION, "registration-secret").map(Secret::new).orElse(new Secret(secret));
    }

    public UsernameAndPassword getServerAuthentication() {
        Optional<String> username = this.config.get(ROUTER_SECTION, "username");
        Optional<String> password = this.config.get(ROUTER_SECTION, "password");
        if (!username.isPresent() || !password.isPresent()) {
            return null;
        }
        return new UsernameAndPassword(username.get(), password.get());
    }

    private boolean isSecure() {
        return this.config.get(SERVER_SECTION, "https-private-key").isPresent() && this.config.get(SERVER_SECTION, "https-certificate").isPresent();
    }

    private boolean isSelfSigned() {
        return this.config.getBool(SERVER_SECTION, "https-self-signed").orElse(false);
    }

    private File getCertificate() {
        String certificatePath = this.config.get(SERVER_SECTION, "https-certificate").orElse(null);
        if (certificatePath != null) {
            return new File(certificatePath);
        }
        throw new ConfigException("You must provide a certificate via --https-certificate when using --https", new Object[0]);
    }
}

