/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.node.relay;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.ImmutableCapabilities;
import org.openqa.selenium.SessionNotCreatedException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.grid.data.CreateSessionRequest;
import org.openqa.selenium.grid.node.ActiveSession;
import org.openqa.selenium.grid.node.DefaultActiveSession;
import org.openqa.selenium.grid.node.SessionFactory;
import org.openqa.selenium.internal.Debug;
import org.openqa.selenium.internal.Either;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.Command;
import org.openqa.selenium.remote.Dialect;
import org.openqa.selenium.remote.DriverCommand;
import org.openqa.selenium.remote.ProtocolHandshake;
import org.openqa.selenium.remote.RemoteTags;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.http.ClientConfig;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpMessage;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.tracing.AttributeKey;
import org.openqa.selenium.remote.tracing.EventAttribute;
import org.openqa.selenium.remote.tracing.EventAttributeValue;
import org.openqa.selenium.remote.tracing.Span;
import org.openqa.selenium.remote.tracing.Status;
import org.openqa.selenium.remote.tracing.Tags;
import org.openqa.selenium.remote.tracing.Tracer;

public class RelaySessionFactory
implements SessionFactory {
    private static final Logger LOG = Logger.getLogger(RelaySessionFactory.class.getName());
    private final Tracer tracer;
    private final HttpClient.Factory clientFactory;
    private final Duration sessionTimeout;
    private final URL serviceUrl;
    private final URL serviceStatusUrl;
    private final Capabilities stereotype;

    public RelaySessionFactory(Tracer tracer, HttpClient.Factory clientFactory, Duration sessionTimeout, URI serviceUri, URI serviceStatusUri, Capabilities stereotype) {
        this.tracer = (Tracer)Require.nonNull((String)"Tracer", (Object)tracer);
        this.clientFactory = (HttpClient.Factory)Require.nonNull((String)"HTTP client", (Object)clientFactory);
        this.sessionTimeout = (Duration)Require.nonNull((String)"Session timeout", (Object)sessionTimeout);
        this.serviceUrl = this.createUrlFromUri((URI)Require.nonNull((String)"Service URL", (Object)serviceUri));
        this.serviceStatusUrl = this.createUrlFromUri(serviceStatusUri);
        this.stereotype = ImmutableCapabilities.copyOf((Capabilities)((Capabilities)Require.nonNull((String)"Stereotype", (Object)stereotype)));
    }

    @Override
    public Capabilities getStereotype() {
        return this.stereotype;
    }

    @Override
    public boolean test(Capabilities capabilities) {
        boolean platformVersionMatch = capabilities.getCapabilityNames().stream().filter(name -> name.contains("platformVersion")).map(platformVersionCapName -> Objects.equals(this.stereotype.getCapability(platformVersionCapName), capabilities.getCapability(platformVersionCapName))).reduce(Boolean::logicalAnd).orElse(true);
        return platformVersionMatch && this.stereotype.getCapabilityNames().stream().filter(name -> capabilities.asMap().containsKey(name)).map(name -> {
            if (capabilities.getCapability(name) instanceof String) {
                return this.stereotype.getCapability(name).toString().equalsIgnoreCase(capabilities.getCapability(name).toString());
            }
            return capabilities.getCapability(name) == null || Objects.equals(this.stereotype.getCapability(name), capabilities.getCapability(name));
        }).reduce(Boolean::logicalAnd).orElse(false) != false;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public Either<WebDriverException, ActiveSession> apply(CreateSessionRequest sessionRequest) {
        Capabilities capabilities = sessionRequest.getDesiredCapabilities();
        if (!this.test(capabilities)) {
            return Either.left((Object)((Object)new SessionNotCreatedException("New session request capabilities do not match the stereotype.")));
        }
        LOG.info("Starting session for " + capabilities);
        try (Span span = this.tracer.getCurrentContext().createSpan("relay_session_factory.apply");){
            HashMap<String, EventAttributeValue> attributeMap = new HashMap<String, EventAttributeValue>();
            RemoteTags.CAPABILITIES.accept(span, capabilities);
            RemoteTags.CAPABILITIES_EVENT.accept(attributeMap, capabilities);
            attributeMap.put(AttributeKey.LOGGER_CLASS.getKey(), EventAttribute.setValue((String)this.getClass().getName()));
            attributeMap.put(AttributeKey.DRIVER_URL.getKey(), EventAttribute.setValue((String)this.serviceUrl.toString()));
            ClientConfig clientConfig = ClientConfig.defaultConfig().readTimeout(this.sessionTimeout).baseUrl(this.serviceUrl);
            HttpClient client = this.clientFactory.createClient(clientConfig);
            Command command = new Command(null, DriverCommand.NEW_SESSION((Capabilities)capabilities));
            try {
                ProtocolHandshake.Result result = new ProtocolHandshake().createSession((HttpHandler)client, command);
                Set<Dialect> downstreamDialects = sessionRequest.getDownstreamDialects();
                Dialect upstream = result.getDialect();
                Dialect downstream = downstreamDialects.contains(result.getDialect()) ? result.getDialect() : downstreamDialects.iterator().next();
                Response response = result.createResponse();
                attributeMap.put(AttributeKey.UPSTREAM_DIALECT.getKey(), EventAttribute.setValue((String)upstream.toString()));
                attributeMap.put(AttributeKey.DOWNSTREAM_DIALECT.getKey(), EventAttribute.setValue((String)downstream.toString()));
                attributeMap.put(AttributeKey.DRIVER_RESPONSE.getKey(), EventAttribute.setValue((String)response.toString()));
                ImmutableCapabilities responseCaps = new ImmutableCapabilities((Map)response.getValue());
                Capabilities mergedCapabilities = capabilities.merge((Capabilities)responseCaps);
                span.addEvent("Relay service created session", attributeMap);
                LOG.fine(String.format("Created session: %s - %s", response.getSessionId(), capabilities));
                Either either = Either.right((Object)new DefaultActiveSession(this.tracer, client, new SessionId(response.getSessionId()), this.serviceUrl, downstream, upstream, this.stereotype, mergedCapabilities, Instant.now()){

                    @Override
                    public void stop() {
                    }
                });
                return either;
            }
            catch (Exception e) {
                Either either2;
                block12: {
                    span.setAttribute(AttributeKey.ERROR.getKey(), true);
                    span.setStatus(Status.CANCELLED);
                    Tags.EXCEPTION.accept(attributeMap, e);
                    String errorMessage = String.format("Error while creating session with the service %s. %s", this.serviceUrl, e.getMessage());
                    attributeMap.put(AttributeKey.EXCEPTION_MESSAGE.getKey(), EventAttribute.setValue((String)errorMessage));
                    span.addEvent(AttributeKey.EXCEPTION_EVENT.getKey(), attributeMap);
                    either2 = Either.left((Object)((Object)new SessionNotCreatedException(errorMessage)));
                    if (span == null) break block12;
                    span.close();
                }
                return either2;
            }
        }
        catch (Exception e2) {
            return Either.left((Object)((Object)new SessionNotCreatedException(e2.getMessage())));
        }
    }

    public boolean isServiceUp() {
        if (this.serviceStatusUrl == null) {
            return true;
        }
        try {
            HttpClient client = this.clientFactory.createClient(this.serviceStatusUrl);
            HttpResponse response = client.execute(new HttpRequest(HttpMethod.GET, this.serviceStatusUrl.toString()));
            LOG.log(Debug.getDebugLogLevel(), Contents.string((HttpMessage)response));
            return response.getStatus() == 200;
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, () -> String.format("Error checking service status %s. %s", this.serviceStatusUrl, e.getMessage()));
            LOG.log(Debug.getDebugLogLevel(), "Error checking service status " + this.serviceStatusUrl, e);
            return false;
        }
    }

    private URL createUrlFromUri(URI uri) {
        if (uri == null) {
            return null;
        }
        try {
            return uri.toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

