/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.graphql;

import java.net.URI;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.grid.graphql.Slot;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.Json;

public class Session {
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("dd/MM/yyyy HH:mm:ss").withZone(ZoneId.systemDefault());
    private final String id;
    private final Capabilities capabilities;
    private final Instant startTime;
    private final URI uri;
    private final String nodeId;
    private final URI nodeUri;
    private final org.openqa.selenium.grid.data.Slot slot;
    private static final Json JSON = new Json();

    public Session(String id, Capabilities capabilities, Instant startTime, URI uri, String nodeId, URI nodeUri, org.openqa.selenium.grid.data.Slot slot) {
        this.id = (String)Require.nonNull((String)"Session id", (Object)id);
        this.capabilities = (Capabilities)Require.nonNull((String)"Session capabilities", (Object)capabilities);
        this.startTime = (Instant)Require.nonNull((String)"Session Start time", (Object)startTime);
        this.uri = (URI)Require.nonNull((String)"Session uri", (Object)uri);
        this.nodeId = (String)Require.nonNull((String)"Node id", (Object)nodeId);
        this.nodeUri = (URI)Require.nonNull((String)"Node uri", (Object)nodeUri);
        this.slot = (org.openqa.selenium.grid.data.Slot)Require.nonNull((String)"Slot", (Object)slot);
    }

    public String getId() {
        return this.id;
    }

    public String getCapabilities() {
        return JSON.toJson((Object)this.capabilities);
    }

    public String getStartTime() {
        return DATE_TIME_FORMATTER.format(this.startTime);
    }

    public URI getUri() {
        return this.uri;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public URI getNodeUri() {
        return this.nodeUri;
    }

    public String getSessionDurationMillis() {
        long duration = Duration.between(this.startTime, Instant.now()).toMillis();
        return String.valueOf(duration);
    }

    public Slot getSlot() {
        return new Slot(this.slot.getId().getSlotId(), this.slot.getStereotype(), this.slot.getLastStarted());
    }
}

