/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.distributor.local;

import com.google.common.collect.ImmutableSet;
import java.io.UncheckedIOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.openqa.selenium.Beta;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.ImmutableCapabilities;
import org.openqa.selenium.RetrySessionRequestException;
import org.openqa.selenium.SessionNotCreatedException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.concurrent.Regularly;
import org.openqa.selenium.events.EventBus;
import org.openqa.selenium.grid.config.Config;
import org.openqa.selenium.grid.data.Availability;
import org.openqa.selenium.grid.data.CreateSessionRequest;
import org.openqa.selenium.grid.data.CreateSessionResponse;
import org.openqa.selenium.grid.data.DistributorStatus;
import org.openqa.selenium.grid.data.NewSessionRequestEvent;
import org.openqa.selenium.grid.data.NodeAddedEvent;
import org.openqa.selenium.grid.data.NodeDrainComplete;
import org.openqa.selenium.grid.data.NodeHeartBeatEvent;
import org.openqa.selenium.grid.data.NodeId;
import org.openqa.selenium.grid.data.NodeStatus;
import org.openqa.selenium.grid.data.NodeStatusEvent;
import org.openqa.selenium.grid.data.RequestId;
import org.openqa.selenium.grid.data.SessionRequest;
import org.openqa.selenium.grid.data.SessionRequestCapability;
import org.openqa.selenium.grid.data.Slot;
import org.openqa.selenium.grid.data.SlotId;
import org.openqa.selenium.grid.data.TraceSessionRequest;
import org.openqa.selenium.grid.distributor.Distributor;
import org.openqa.selenium.grid.distributor.config.DistributorOptions;
import org.openqa.selenium.grid.distributor.local.GridModel;
import org.openqa.selenium.grid.distributor.selector.SlotSelector;
import org.openqa.selenium.grid.log.LoggingOptions;
import org.openqa.selenium.grid.node.HealthCheck;
import org.openqa.selenium.grid.node.Node;
import org.openqa.selenium.grid.node.remote.RemoteNode;
import org.openqa.selenium.grid.security.Secret;
import org.openqa.selenium.grid.security.SecretOptions;
import org.openqa.selenium.grid.server.EventBusOptions;
import org.openqa.selenium.grid.server.NetworkOptions;
import org.openqa.selenium.grid.sessionmap.SessionMap;
import org.openqa.selenium.grid.sessionmap.config.SessionMapOptions;
import org.openqa.selenium.grid.sessionqueue.NewSessionQueue;
import org.openqa.selenium.grid.sessionqueue.config.NewSessionQueueOptions;
import org.openqa.selenium.internal.Debug;
import org.openqa.selenium.internal.Either;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.RemoteTags;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.tracing.AttributeKey;
import org.openqa.selenium.remote.tracing.EventAttribute;
import org.openqa.selenium.remote.tracing.EventAttributeValue;
import org.openqa.selenium.remote.tracing.Span;
import org.openqa.selenium.remote.tracing.Status;
import org.openqa.selenium.remote.tracing.Tags;
import org.openqa.selenium.remote.tracing.Tracer;
import org.openqa.selenium.status.HasReadyState;

public class LocalDistributor
extends Distributor {
    private static final Logger LOG = Logger.getLogger(LocalDistributor.class.getName());
    private final Tracer tracer;
    private final EventBus bus;
    private final HttpClient.Factory clientFactory;
    private final SessionMap sessions;
    private final SlotSelector slotSelector;
    private final Secret registrationSecret;
    private final Regularly hostChecker = new Regularly("distributor host checker");
    private final Map<NodeId, Runnable> allChecks = new HashMap<NodeId, Runnable>();
    private final Duration healthcheckInterval;
    private final ReadWriteLock lock = new ReentrantReadWriteLock(true);
    private final GridModel model;
    private final Map<NodeId, Node> nodes;
    private final NewSessionQueue sessionQueue;
    private final Regularly regularly;
    private final boolean rejectUnsupportedCaps;

    public LocalDistributor(Tracer tracer, EventBus bus, HttpClient.Factory clientFactory, SessionMap sessions, NewSessionQueue sessionQueue, SlotSelector slotSelector, Secret registrationSecret, Duration healthcheckInterval, boolean rejectUnsupportedCaps) {
        super(tracer, clientFactory, registrationSecret);
        this.tracer = (Tracer)Require.nonNull((String)"Tracer", (Object)tracer);
        this.bus = (EventBus)Require.nonNull((String)"Event bus", (Object)bus);
        this.clientFactory = (HttpClient.Factory)Require.nonNull((String)"HTTP client factory", (Object)clientFactory);
        this.sessions = (SessionMap)Require.nonNull((String)"Session map", (Object)sessions);
        this.sessionQueue = (NewSessionQueue)Require.nonNull((String)"New Session Request Queue", (Object)sessionQueue);
        this.slotSelector = (SlotSelector)Require.nonNull((String)"Slot selector", (Object)slotSelector);
        this.registrationSecret = (Secret)Require.nonNull((String)"Registration secret", (Object)registrationSecret);
        this.healthcheckInterval = (Duration)Require.nonNull((String)"Health check interval", (Object)healthcheckInterval);
        this.model = new GridModel(bus);
        this.nodes = new ConcurrentHashMap<NodeId, Node>();
        this.rejectUnsupportedCaps = rejectUnsupportedCaps;
        bus.addListener(NodeStatusEvent.listener(this::register));
        bus.addListener(NodeStatusEvent.listener(this.model::refresh));
        bus.addListener(NodeHeartBeatEvent.listener(nodeStatus -> {
            if (this.nodes.containsKey(nodeStatus.getId())) {
                this.model.touch(nodeStatus.getId());
            } else {
                this.register((NodeStatus)nodeStatus);
            }
        }));
        this.regularly = new Regularly(Executors.newSingleThreadScheduledExecutor(r -> {
            Thread thread = new Thread(r);
            thread.setName("New Session Queue");
            thread.setDaemon(true);
            return thread;
        }));
        NewSessionRunnable newSessionRunnable = new NewSessionRunnable();
        bus.addListener(NodeDrainComplete.listener(this::remove));
        bus.addListener(NewSessionRequestEvent.listener(ignored -> newSessionRunnable.run()));
        this.regularly.submit(this.model::purgeDeadNodes, Duration.ofSeconds(30L), Duration.ofSeconds(30L));
        this.regularly.submit(newSessionRunnable, Duration.ofSeconds(5L), Duration.ofSeconds(5L));
    }

    public static Distributor create(Config config) {
        Tracer tracer = new LoggingOptions(config).getTracer();
        EventBus bus = new EventBusOptions(config).getEventBus();
        DistributorOptions distributorOptions = new DistributorOptions(config);
        HttpClient.Factory clientFactory = new NetworkOptions(config).getHttpClientFactory(tracer);
        SessionMap sessions = new SessionMapOptions(config).getSessionMap();
        SecretOptions secretOptions = new SecretOptions(config);
        NewSessionQueue sessionQueue = new NewSessionQueueOptions(config).getSessionQueue("org.openqa.selenium.grid.sessionqueue.remote.RemoteNewSessionQueue");
        return new LocalDistributor(tracer, bus, clientFactory, sessions, sessionQueue, distributorOptions.getSlotSelector(), secretOptions.getRegistrationSecret(), distributorOptions.getHealthCheckInterval(), distributorOptions.shouldRejectUnsupportedCaps());
    }

    @Override
    public boolean isReady() {
        try {
            return ImmutableSet.of((Object)this.bus, (Object)this.sessions).parallelStream().map(HasReadyState::isReady).reduce(true, Boolean::logicalAnd);
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void register(NodeStatus status) {
        Require.nonNull((String)"Node", (Object)status);
        Lock writeLock = this.lock.writeLock();
        writeLock.lock();
        try {
            if (this.nodes.containsKey(status.getId())) {
                return;
            }
            Set capabilities = (Set)status.getSlots().stream().map(Slot::getStereotype).map(ImmutableCapabilities::copyOf).collect(ImmutableSet.toImmutableSet());
            RemoteNode remoteNode = new RemoteNode(this.tracer, this.clientFactory, status.getId(), status.getUri(), this.registrationSecret, capabilities);
            this.add(remoteNode);
        }
        finally {
            writeLock.unlock();
        }
    }

    @Override
    public LocalDistributor add(Node node) {
        Require.nonNull((String)"Node", (Object)node);
        LOG.info(String.format("Added node %s at %s.", node.getId(), node.getUri()));
        this.nodes.put(node.getId(), node);
        this.model.add(node.getStatus());
        Runnable runnableHealthCheck = this.asRunnableHealthCheck(node);
        this.allChecks.put(node.getId(), runnableHealthCheck);
        this.hostChecker.submit(runnableHealthCheck, this.healthcheckInterval, Duration.ofSeconds(30L));
        this.bus.fire(new NodeAddedEvent(node.getId()));
        return this;
    }

    private Runnable asRunnableHealthCheck(Node node) {
        HealthCheck healthCheck = node.getHealthCheck();
        NodeId id = node.getId();
        return () -> {
            HealthCheck.Result result;
            try {
                result = healthCheck.check();
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "Unable to process node " + id, e);
                result = new HealthCheck.Result(Availability.DOWN, "Unable to run healthcheck. Assuming down");
            }
            Lock writeLock = this.lock.writeLock();
            writeLock.lock();
            try {
                this.model.setAvailability(id, result.getAvailability());
            }
            finally {
                writeLock.unlock();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean drain(NodeId nodeId) {
        Node node = this.nodes.get(nodeId);
        if (node == null) {
            LOG.info("Asked to drain unregistered node " + nodeId);
            return false;
        }
        Lock writeLock = this.lock.writeLock();
        writeLock.lock();
        try {
            node.drain();
            this.model.setAvailability(nodeId, Availability.DRAINING);
        }
        finally {
            writeLock.unlock();
        }
        return node.isDraining();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(NodeId nodeId) {
        Lock writeLock = this.lock.writeLock();
        writeLock.lock();
        try {
            this.model.remove(nodeId);
            Runnable runnable = this.allChecks.remove(nodeId);
            if (runnable != null) {
                this.hostChecker.remove(runnable);
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    @Override
    public DistributorStatus getStatus() {
        Lock readLock = this.lock.readLock();
        readLock.lock();
        try {
            DistributorStatus distributorStatus = new DistributorStatus(this.model.getSnapshot());
            return distributorStatus;
        }
        finally {
            readLock.unlock();
        }
    }

    @Beta
    public void refresh() {
        ArrayList<Runnable> allHealthChecks = new ArrayList<Runnable>();
        Lock readLock = this.lock.readLock();
        readLock.lock();
        try {
            allHealthChecks.addAll(this.allChecks.values());
        }
        finally {
            readLock.unlock();
        }
        allHealthChecks.parallelStream().forEach(Runnable::run);
    }

    protected Set<NodeStatus> getAvailableNodes() {
        Lock readLock = this.lock.readLock();
        readLock.lock();
        try {
            Set set = (Set)this.model.getSnapshot().stream().filter(node -> !Availability.DOWN.equals((Object)node.getAvailability())).collect(ImmutableSet.toImmutableSet());
            return set;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Either<SessionNotCreatedException, CreateSessionResponse> newSession(SessionRequest request) throws SessionNotCreatedException {
        SessionNotCreatedException lastFailure;
        block15: {
            HashMap<String, EventAttributeValue> attributeMap;
            Span span;
            block14: {
                Require.nonNull((String)"Requests to process", (Object)request);
                span = this.tracer.getCurrentContext().createSpan("distributor.new_session");
                attributeMap = new HashMap<String, EventAttributeValue>();
                try {
                    attributeMap.put(AttributeKey.LOGGER_CLASS.getKey(), EventAttribute.setValue((String)this.getClass().getName()));
                    attributeMap.put("request.payload", EventAttribute.setValue((String)request.getDesiredCapabilities().toString()));
                    String sessionReceivedMessage = "Session request received by the distributor";
                    span.addEvent(sessionReceivedMessage, attributeMap);
                    LOG.info(String.format("%s: \n %s", sessionReceivedMessage, request.getDesiredCapabilities()));
                    if (request.getDesiredCapabilities().isEmpty()) {
                        SessionNotCreatedException exception = new SessionNotCreatedException("No capabilities found in session request payload");
                        Tags.EXCEPTION.accept(attributeMap, exception);
                        attributeMap.put(AttributeKey.EXCEPTION_MESSAGE.getKey(), EventAttribute.setValue((String)("Unable to create session. No capabilities found: " + exception.getMessage())));
                        span.addEvent(AttributeKey.EXCEPTION_EVENT.getKey(), attributeMap);
                        Either either = Either.left((Object)((Object)exception));
                        return either;
                    }
                    boolean retry = false;
                    lastFailure = new SessionNotCreatedException("Unable to create new session");
                    for (Capabilities caps : request.getDesiredCapabilities()) {
                        if (!this.isSupported(caps)) continue;
                        SlotId selectedSlot = this.reserveSlot(request.getRequestId(), caps);
                        if (selectedSlot == null) {
                            LOG.info(String.format("Unable to find slot for request %s. May retry: %s ", request.getRequestId(), caps));
                            retry = true;
                            continue;
                        }
                        CreateSessionRequest singleRequest = new CreateSessionRequest(request.getDownstreamDialects(), caps, request.getMetadata());
                        try {
                            CreateSessionResponse response = this.startSession(selectedSlot, singleRequest);
                            this.sessions.add(response.getSession());
                            this.model.setSession(selectedSlot, response.getSession());
                            SessionId sessionId = response.getSession().getId();
                            Capabilities sessionCaps = response.getSession().getCapabilities();
                            String sessionUri = response.getSession().getUri().toString();
                            RemoteTags.SESSION_ID.accept(span, sessionId);
                            RemoteTags.CAPABILITIES.accept(span, sessionCaps);
                            RemoteTags.SESSION_ID_EVENT.accept(attributeMap, sessionId);
                            RemoteTags.CAPABILITIES_EVENT.accept(attributeMap, sessionCaps);
                            span.setAttribute(AttributeKey.SESSION_URI.getKey(), sessionUri);
                            attributeMap.put(AttributeKey.SESSION_URI.getKey(), EventAttribute.setValue((String)sessionUri));
                            String sessionCreatedMessage = "Session created by the distributor";
                            span.addEvent(sessionCreatedMessage, attributeMap);
                            LOG.info(String.format("%s. Id: %s, Caps: %s", sessionCreatedMessage, sessionId, sessionCaps));
                            Either either = Either.right((Object)response);
                            return either;
                        }
                        catch (SessionNotCreatedException e) {
                            this.model.setSession(selectedSlot, null);
                            lastFailure = e;
                        }
                    }
                    if (!retry) break block14;
                }
                catch (SessionNotCreatedException e) {
                    span.setAttribute(AttributeKey.ERROR.getKey(), true);
                    span.setStatus(Status.ABORTED);
                    Tags.EXCEPTION.accept(attributeMap, e);
                    attributeMap.put(AttributeKey.EXCEPTION_MESSAGE.getKey(), EventAttribute.setValue((String)("Unable to create session: " + e.getMessage())));
                    span.addEvent(AttributeKey.EXCEPTION_EVENT.getKey(), attributeMap);
                    Either either = Either.left((Object)((Object)e));
                    return either;
                }
                catch (UncheckedIOException e) {
                    span.setAttribute(AttributeKey.ERROR.getKey(), true);
                    span.setStatus(Status.UNKNOWN);
                    Tags.EXCEPTION.accept(attributeMap, e);
                    attributeMap.put(AttributeKey.EXCEPTION_MESSAGE.getKey(), EventAttribute.setValue((String)("Unknown error in LocalDistributor while creating session: " + e.getMessage())));
                    span.addEvent(AttributeKey.EXCEPTION_EVENT.getKey(), attributeMap);
                    Either either = Either.left((Object)((Object)new SessionNotCreatedException(e.getMessage(), (Throwable)e)));
                    return either;
                }
                finally {
                    span.close();
                }
                lastFailure = new RetrySessionRequestException("Will re-attempt to find a node which can run this session", (Throwable)lastFailure);
                attributeMap.put(AttributeKey.EXCEPTION_MESSAGE.getKey(), EventAttribute.setValue((String)("Will retry session " + request.getRequestId())));
                break block15;
            }
            Tags.EXCEPTION.accept(attributeMap, lastFailure);
            attributeMap.put(AttributeKey.EXCEPTION_MESSAGE.getKey(), EventAttribute.setValue((String)("Unable to create session: " + lastFailure.getMessage())));
            span.addEvent(AttributeKey.EXCEPTION_EVENT.getKey(), attributeMap);
        }
        Either either = Either.left((Object)((Object)lastFailure));
        return either;
    }

    private CreateSessionResponse startSession(SlotId selectedSlot, CreateSessionRequest singleRequest) {
        Either result;
        Node node = this.nodes.get(selectedSlot.getOwningNodeId());
        if (node == null) {
            throw new SessionNotCreatedException("Unable to find owning node for slot");
        }
        try {
            result = node.newSession(singleRequest);
        }
        catch (SessionNotCreatedException e) {
            result = Either.left((Object)((Object)e));
        }
        catch (RuntimeException e) {
            result = Either.left((Object)((Object)new SessionNotCreatedException(e.getMessage(), (Throwable)e)));
        }
        if (result.isLeft()) {
            WebDriverException exception = (WebDriverException)result.left();
            if (exception instanceof SessionNotCreatedException) {
                throw exception;
            }
            throw new SessionNotCreatedException(exception.getMessage(), (Throwable)exception);
        }
        return (CreateSessionResponse)result.right();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SlotId reserveSlot(RequestId requestId, Capabilities caps) {
        Lock writeLock = this.lock.writeLock();
        writeLock.lock();
        try {
            Set<SlotId> slotIds = this.slotSelector.selectSlot(caps, this.getAvailableNodes());
            if (slotIds.isEmpty()) {
                LOG.log(Debug.getDebugLogLevel(), String.format("No slots found for request %s and capabilities %s", requestId, caps));
                SlotId slotId = null;
                return slotId;
            }
            for (SlotId slotId : slotIds) {
                if (!this.reserve(slotId)) continue;
                SlotId slotId2 = slotId;
                return slotId2;
            }
            Iterator<SlotId> iterator = null;
            return iterator;
        }
        finally {
            writeLock.unlock();
        }
    }

    private boolean isSupported(Capabilities caps) {
        return this.getAvailableNodes().stream().anyMatch(node -> node.hasCapability(caps));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean reserve(SlotId id) {
        Require.nonNull((String)"Slot ID", (Object)id);
        Lock writeLock = this.lock.writeLock();
        writeLock.lock();
        try {
            Node node = this.nodes.get(id.getOwningNodeId());
            if (node == null) {
                LOG.log(Debug.getDebugLogLevel(), String.format("Unable to find node with id %s", id));
                boolean bl = false;
                return bl;
            }
            boolean bl = this.model.reserve(id);
            return bl;
        }
        finally {
            writeLock.unlock();
        }
    }

    public void callExecutorShutdown() {
        LOG.info("Shutting down Distributor executor service");
        this.regularly.shutdown();
    }

    public class NewSessionRunnable
    implements Runnable {
        @Override
        public void run() {
            int initialSize;
            boolean retry;
            List<SessionRequestCapability> queueContents = LocalDistributor.this.sessionQueue.getQueueContents();
            if (LocalDistributor.this.rejectUnsupportedCaps) {
                this.checkMatchingSlot(queueContents);
            }
            boolean bl = retry = (initialSize = queueContents.size()) != 0;
            while (retry) {
                Set<Capabilities> stereotypes = LocalDistributor.this.getAvailableNodes().stream().filter(NodeStatus::hasCapacity).map(node -> node.getSlots().stream().map(Slot::getStereotype).collect(Collectors.toSet())).flatMap(Collection::stream).collect(Collectors.toSet());
                Optional<SessionRequest> maybeRequest = LocalDistributor.this.sessionQueue.getNextAvailable(stereotypes);
                maybeRequest.ifPresent(this::handleNewSessionRequest);
                int currentSize = LocalDistributor.this.sessionQueue.getQueueContents().size();
                retry = currentSize != 0 && currentSize != initialSize;
                initialSize = currentSize;
            }
        }

        private void checkMatchingSlot(List<SessionRequestCapability> sessionRequests) {
            for (SessionRequestCapability request : sessionRequests) {
                long unmatchableCount = request.getDesiredCapabilities().stream().filter(caps -> !LocalDistributor.this.isSupported(caps)).count();
                if (unmatchableCount != (long)request.getDesiredCapabilities().size()) continue;
                SessionNotCreatedException exception = new SessionNotCreatedException("No nodes support the capabilities in the request");
                LocalDistributor.this.sessionQueue.complete(request.getRequestId(), (Either<SessionNotCreatedException, CreateSessionResponse>)Either.left((Object)exception));
            }
        }

        private void handleNewSessionRequest(SessionRequest sessionRequest) {
            RequestId reqId = sessionRequest.getRequestId();
            try (Span span = TraceSessionRequest.extract(LocalDistributor.this.tracer, sessionRequest).createSpan("distributor.poll_queue");){
                HashMap<String, EventAttributeValue> attributeMap = new HashMap<String, EventAttributeValue>();
                attributeMap.put(AttributeKey.LOGGER_CLASS.getKey(), EventAttribute.setValue((String)this.getClass().getName()));
                span.setAttribute(AttributeKey.REQUEST_ID.getKey(), reqId.toString());
                attributeMap.put(AttributeKey.REQUEST_ID.getKey(), EventAttribute.setValue((String)reqId.toString()));
                attributeMap.put("request", EventAttribute.setValue((String)sessionRequest.toString()));
                Either<SessionNotCreatedException, CreateSessionResponse> response = LocalDistributor.this.newSession(sessionRequest);
                if (response.isLeft() && response.left() instanceof RetrySessionRequestException) {
                    try (Span childSpan = span.createSpan("distributor.retry");){
                        LOG.info("Retrying");
                        boolean retried = LocalDistributor.this.sessionQueue.retryAddToQueue(sessionRequest);
                        attributeMap.put("request.retry_add", EventAttribute.setValue((boolean)retried));
                        childSpan.addEvent("Retry adding to front of queue. No slot available.", attributeMap);
                        if (retried) {
                            return;
                        }
                        childSpan.addEvent("retrying_request", attributeMap);
                    }
                }
                LocalDistributor.this.sessionQueue.complete(reqId, response);
            }
        }
    }
}

