/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.docker;

import org.openqa.selenium.internal.Require;

class Version {
    private final String versionString;
    private final String[] segments;

    public Version(String versionString) {
        this.versionString = (String)Require.nonNull((String)"Version string", (Object)versionString);
        this.segments = versionString.split("\\.");
    }

    public boolean equalTo(Version other) {
        int max = Math.max(this.segments.length, other.segments.length);
        for (int i = 0; i < max; ++i) {
            if (this.compare(this.segments, other.segments, i) == 0) continue;
            return false;
        }
        return true;
    }

    public boolean isLessThan(Version other) {
        int max = Math.max(this.segments.length, other.segments.length);
        for (int i = 0; i < max; ++i) {
            if (this.compare(this.segments, other.segments, i) <= 0) continue;
            return false;
        }
        return !this.equalTo(other);
    }

    public boolean isGreaterThan(Version other) {
        int max = Math.max(this.segments.length, other.segments.length);
        for (int i = 0; i < max; ++i) {
            if (this.compare(this.segments, other.segments, i) >= 0) continue;
            return false;
        }
        return !this.equalTo(other);
    }

    public String toString() {
        return this.versionString;
    }

    private int compare(String[] ours, String[] theirs, int index) {
        try {
            long mine = index < ours.length ? Long.parseLong(ours[index]) : 0L;
            long others = index < theirs.length ? Long.parseLong(theirs[index]) : 0L;
            return Long.compare(mine, others);
        }
        catch (NumberFormatException e) {
            String others;
            String mine;
            String string = mine = index < ours.length ? ours[index] : "";
            if (mine == null) {
                mine = "";
            }
            String string2 = others = index < theirs.length ? theirs[index] : "";
            if (others == null) {
                others = "";
            }
            return mine.compareTo(others);
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof Version)) {
            return false;
        }
        Version that = (Version)o;
        return this.equalTo(that);
    }

    public int hashCode() {
        return this.versionString.hashCode();
    }
}

