/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.sessionqueue;

import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.grid.data.RequestId;
import org.openqa.selenium.grid.security.RequiresSecretFilter;
import org.openqa.selenium.grid.security.Secret;
import org.openqa.selenium.grid.sessionqueue.AddBackToSessionQueue;
import org.openqa.selenium.grid.sessionqueue.AddToSessionQueue;
import org.openqa.selenium.grid.sessionqueue.ClearSessionQueue;
import org.openqa.selenium.grid.sessionqueue.GetSessionQueue;
import org.openqa.selenium.grid.sessionqueue.RemoveFromSessionQueue;
import org.openqa.selenium.grid.sessionqueue.SessionRequest;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.NewSessionPayload;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.Filter;
import org.openqa.selenium.remote.http.HttpMessage;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.http.Routable;
import org.openqa.selenium.remote.http.Route;
import org.openqa.selenium.remote.tracing.Tracer;
import org.openqa.selenium.status.HasReadyState;

public abstract class NewSessionQueuer
implements HasReadyState,
Routable {
    protected final Tracer tracer;
    private final Route routes;

    protected NewSessionQueuer(Tracer tracer, Secret registrationSecret) {
        this.tracer = (Tracer)Require.nonNull((String)"Tracer", (Object)tracer);
        Require.nonNull((String)"Registration secret", (Object)registrationSecret);
        RequiresSecretFilter requiresSecret = new RequiresSecretFilter(registrationSecret);
        this.routes = Route.combine((Routable)Route.post((String)"/session").to(() -> req -> {
            try (Reader reader = Contents.reader((HttpMessage)req);){
                HttpResponse httpResponse;
                block14: {
                    NewSessionPayload payload = NewSessionPayload.create((Reader)reader);
                    try {
                        SessionRequest sessionRequest = new SessionRequest(new RequestId(UUID.randomUUID()), Instant.now(), payload.getDownstreamDialects(), payload.stream().collect(Collectors.toSet()));
                        httpResponse = this.addToQueue(sessionRequest);
                        if (payload == null) break block14;
                    }
                    catch (Throwable throwable) {
                        if (payload != null) {
                            try {
                                payload.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    payload.close();
                }
                return httpResponse;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }), (Routable[])new Routable[]{Route.post((String)"/se/grid/newsessionqueuer/session").to(() -> new AddToSessionQueue(tracer, this)), Route.post((String)"/se/grid/newsessionqueuer/session/retry/{requestId}").to(params -> new AddBackToSessionQueue(tracer, this, this.requestIdFrom((Map<String, String>)params))).with((Filter)requiresSecret), Route.get((String)"/se/grid/newsessionqueuer/session/{requestId}").to(params -> new RemoveFromSessionQueue(tracer, this, this.requestIdFrom((Map<String, String>)params))).with((Filter)requiresSecret), Route.get((String)"/se/grid/newsessionqueuer/queue").to(() -> new GetSessionQueue(tracer, this)), Route.delete((String)"/se/grid/newsessionqueuer/queue").to(() -> new ClearSessionQueue(tracer, this)).with((Filter)requiresSecret)});
    }

    private RequestId requestIdFrom(Map<String, String> params) {
        return new RequestId(UUID.fromString(params.get("requestId")));
    }

    public abstract HttpResponse addToQueue(SessionRequest var1);

    public abstract boolean retryAddToQueue(SessionRequest var1);

    public abstract Optional<SessionRequest> remove(RequestId var1);

    public abstract int clearQueue();

    public abstract List<Set<Capabilities>> getQueueContents();

    public boolean matches(HttpRequest req) {
        return this.routes.matches(req);
    }

    public HttpResponse execute(HttpRequest req) {
        return this.routes.execute(req);
    }
}

