/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.graphql;

import com.google.common.base.Suppliers;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.openqa.selenium.grid.data.DistributorStatus;
import org.openqa.selenium.grid.data.NodeStatus;
import org.openqa.selenium.grid.data.Slot;
import org.openqa.selenium.grid.distributor.Distributor;
import org.openqa.selenium.grid.graphql.Session;
import org.openqa.selenium.grid.graphql.SessionNotFoundException;
import org.openqa.selenium.internal.Require;

public class SessionData
implements DataFetcher {
    private final Supplier<DistributorStatus> distributorStatus = Suppliers.memoize(((Distributor)Require.nonNull((String)"Distributor", (Object)distributor))::getStatus);

    public SessionData(Distributor distributor) {
    }

    public Object get(DataFetchingEnvironment environment) {
        String sessionId = (String)environment.getArgument("id");
        if (sessionId.isEmpty()) {
            throw new SessionNotFoundException("Session id is empty. A valid session id is required.");
        }
        Set<NodeStatus> nodeStatuses = this.distributorStatus.get().getNodes();
        SessionInSlot currentSession = this.findSession(sessionId, nodeStatuses);
        if (currentSession != null) {
            org.openqa.selenium.grid.data.Session session = currentSession.session;
            return new Session(session.getId().toString(), session.getCapabilities(), session.getStartTime(), session.getUri(), currentSession.node.getId().toString(), currentSession.node.getUri(), currentSession.slot);
        }
        throw new SessionNotFoundException("No ongoing session found with the requested session id.", sessionId);
    }

    private SessionInSlot findSession(String sessionId, Set<NodeStatus> nodeStatuses) {
        for (NodeStatus status : nodeStatuses) {
            for (Slot slot : status.getSlots()) {
                Optional<org.openqa.selenium.grid.data.Session> session = slot.getSession();
                if (!session.isPresent() || !sessionId.equals(session.get().getId().toString())) continue;
                return new SessionInSlot(session.get(), status, slot);
            }
        }
        return null;
    }

    private static class SessionInSlot {
        private final org.openqa.selenium.grid.data.Session session;
        private final NodeStatus node;
        private final Slot slot;

        SessionInSlot(org.openqa.selenium.grid.data.Session session, NodeStatus node, Slot slot) {
            this.session = session;
            this.node = node;
            this.slot = slot;
        }
    }
}

