/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.sessionqueue;

import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import org.openqa.selenium.grid.data.RequestId;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.tracing.Tracer;
import org.openqa.selenium.status.HasReadyState;

public abstract class NewSessionQueue
implements HasReadyState {
    public static final String SESSIONREQUEST_TIMESTAMP_HEADER = "new-session-request-timestamp";
    public static final String SESSIONREQUEST_ID_HEADER = "request-id";
    protected final Tracer tracer;
    protected final Duration retryInterval;
    protected final Duration requestTimeout;

    protected NewSessionQueue(Tracer tracer, Duration retryInterval, Duration requestTimeout) {
        this.tracer = (Tracer)Require.nonNull((String)"Tracer", (Object)tracer);
        this.retryInterval = (Duration)Require.nonNull((String)"Session request retry interval", (Object)retryInterval);
        this.requestTimeout = (Duration)Require.nonNull((String)"Session request timeout", (Object)requestTimeout);
    }

    public abstract boolean offerLast(HttpRequest var1, RequestId var2);

    public abstract boolean offerFirst(HttpRequest var1, RequestId var2);

    public abstract Optional<HttpRequest> remove(RequestId var1);

    public abstract int clear();

    public abstract int getQueueSize();

    public abstract List<Object> getQueuedRequests();

    public void addRequestHeaders(HttpRequest request, RequestId reqId) {
        long timestamp = Instant.now().getEpochSecond();
        request.addHeader(SESSIONREQUEST_TIMESTAMP_HEADER, Long.toString(timestamp));
        request.addHeader(SESSIONREQUEST_ID_HEADER, reqId.toString());
    }

    public boolean hasRequestTimedOut(HttpRequest request) {
        Instant deque;
        String enqueTimestampStr = request.getHeader(SESSIONREQUEST_TIMESTAMP_HEADER);
        Instant enque = Instant.ofEpochSecond(Long.parseLong(enqueTimestampStr));
        Duration duration = Duration.between(enque, deque = Instant.now());
        return duration.compareTo(this.requestTimeout) > 0;
    }
}

