/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.sessionqueue;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openqa.selenium.events.EventBus;
import org.openqa.selenium.grid.data.NewSessionErrorResponse;
import org.openqa.selenium.grid.data.NewSessionRejectedEvent;
import org.openqa.selenium.grid.data.NewSessionRequest;
import org.openqa.selenium.grid.data.NewSessionResponse;
import org.openqa.selenium.grid.data.NewSessionResponseEvent;
import org.openqa.selenium.grid.data.RequestId;
import org.openqa.selenium.grid.sessionqueue.NewSessionQueue;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.tracing.Tracer;

public class GetNewSessionResponse {
    private static final Logger LOG = Logger.getLogger(GetNewSessionResponse.class.getName());
    private static final Map<RequestId, NewSessionRequest> knownRequests = new ConcurrentHashMap<RequestId, NewSessionRequest>();
    private final EventBus bus;
    private final Tracer tracer;
    private final NewSessionQueue sessionRequests;
    private final ReadWriteLock lock = new ReentrantReadWriteLock(true);

    public GetNewSessionResponse(Tracer tracer, EventBus bus, NewSessionQueue sessionRequests) {
        this.tracer = (Tracer)Require.nonNull((String)"Tracer", (Object)tracer);
        this.bus = (EventBus)Require.nonNull((String)"Event bus", (Object)bus);
        this.sessionRequests = (NewSessionQueue)Require.nonNull((String)"New Session Request Queue", (Object)sessionRequests);
        this.bus.addListener(NewSessionResponseEvent.listener(this::setResponse));
        this.bus.addListener(NewSessionRejectedEvent.listener(this::setErrorResponse));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setResponse(NewSessionResponse sessionResponse) {
        Lock writeLock = this.lock.writeLock();
        writeLock.lock();
        try {
            RequestId id = sessionResponse.getRequestId();
            Optional<NewSessionRequest> sessionRequest = Optional.ofNullable(knownRequests.get(id));
            if (sessionRequest.isPresent()) {
                NewSessionRequest request = sessionRequest.get();
                request.setSessionResponse((HttpResponse)new HttpResponse().setContent(Contents.bytes((byte[])sessionResponse.getDownstreamEncodedResponse())));
                request.getLatch().countDown();
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setErrorResponse(NewSessionErrorResponse sessionResponse) {
        Lock writeLock = this.lock.writeLock();
        writeLock.lock();
        try {
            RequestId id = sessionResponse.getRequestId();
            Optional<NewSessionRequest> sessionRequest = Optional.ofNullable(knownRequests.get(id));
            if (sessionRequest.isPresent()) {
                NewSessionRequest request = sessionRequest.get();
                request.setSessionResponse(this.internalErrorResponse(sessionResponse.getMessage()));
                request.getLatch().countDown();
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpResponse add(HttpRequest request) {
        Require.nonNull((String)"New Session request", (Object)request);
        CountDownLatch latch = new CountDownLatch(1);
        UUID uuid = UUID.randomUUID();
        RequestId requestId = new RequestId(uuid);
        NewSessionRequest requestIdentifier = new NewSessionRequest(requestId, latch);
        knownRequests.put(requestId, requestIdentifier);
        if (!this.sessionRequests.offerLast(request, requestId)) {
            return this.internalErrorResponse("Session request could not be created. Error while adding to the session queue.");
        }
        try {
            latch.await();
            HttpResponse httpResponse = requestIdentifier.getSessionResponse();
            return httpResponse;
        }
        catch (InterruptedException e) {
            LOG.log(Level.WARNING, "The thread waiting for new session response interrupted. {0}", e.getMessage());
            Thread.currentThread().interrupt();
            HttpResponse httpResponse = this.internalErrorResponse("Session request could not be created. Error while processing the session request.");
            return httpResponse;
        }
        finally {
            this.removeRequest(requestId);
        }
    }

    private HttpResponse internalErrorResponse(String message) {
        return (HttpResponse)new HttpResponse().setStatus(500).setContent(Contents.asJson(Collections.singletonMap("value", Collections.singletonMap("message", message))));
    }

    private void removeRequest(RequestId id) {
        knownRequests.remove(id);
    }
}

