/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.node.config;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.function.Function;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.SessionNotCreatedException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverInfo;
import org.openqa.selenium.grid.config.Config;
import org.openqa.selenium.grid.config.ConfigException;
import org.openqa.selenium.grid.node.Node;
import org.openqa.selenium.grid.node.SessionFactory;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.json.JsonOutput;
import org.openqa.selenium.remote.service.DriverService;

public class NodeOptions {
    private static final String NODE_SECTION = "node";
    private static final Logger LOG = Logger.getLogger(NodeOptions.class.getName());
    private static final Json JSON = new Json();
    private static final String DEFAULT_IMPL = "org.openqa.selenium.grid.node.local.LocalNodeFactory";
    private final Config config;

    public NodeOptions(Config config) {
        this.config = (Config)Require.nonNull((String)"Config", (Object)config);
    }

    public Optional<URI> getPublicGridUri() {
        return this.config.get(NODE_SECTION, "grid-url").map(url -> {
            try {
                return new URI((String)url);
            }
            catch (URISyntaxException e) {
                throw new ConfigException("Unable to construct public URL: " + url, new Object[0]);
            }
        });
    }

    public Node getNode() {
        return this.config.getClass(NODE_SECTION, "implementation", Node.class, DEFAULT_IMPL);
    }

    public Duration getRegisterCycle() {
        int seconds = Math.max(this.config.getInt(NODE_SECTION, "register-cycle").orElse(10), 1);
        return Duration.ofSeconds(seconds);
    }

    public Duration getRegisterPeriod() {
        int seconds = Math.max(this.config.getInt(NODE_SECTION, "register-period").orElse(120), 1);
        return Duration.ofSeconds(seconds);
    }

    public Map<Capabilities, Collection<SessionFactory>> getSessionFactories(Function<Capabilities, Collection<SessionFactory>> factoryFactory) {
        int maxSessions = this.getMaxSessions();
        Map<WebDriverInfo, Collection<SessionFactory>> allDrivers = this.discoverDrivers(maxSessions, factoryFactory);
        ImmutableMultimap.Builder sessionFactories = ImmutableMultimap.builder();
        this.addDriverFactoriesFromConfig((ImmutableMultimap.Builder<Capabilities, SessionFactory>)sessionFactories);
        this.addSpecificDrivers(allDrivers, (ImmutableMultimap.Builder<Capabilities, SessionFactory>)sessionFactories);
        this.addDetectedDrivers(allDrivers, (ImmutableMultimap.Builder<Capabilities, SessionFactory>)sessionFactories);
        this.addDriverConfigs(factoryFactory, (ImmutableMultimap.Builder<Capabilities, SessionFactory>)sessionFactories);
        return sessionFactories.build().asMap();
    }

    public int getMaxSessions() {
        return Math.min(this.config.getInt(NODE_SECTION, "max-concurrent-sessions").orElse(Runtime.getRuntime().availableProcessors()), Runtime.getRuntime().availableProcessors());
    }

    private void addDriverFactoriesFromConfig(ImmutableMultimap.Builder<Capabilities, SessionFactory> sessionFactories) {
        this.config.getAll(NODE_SECTION, "driver-factories").ifPresent(allConfigs -> {
            if (allConfigs.size() % 2 != 0) {
                throw new ConfigException("Expected each driver class to be mapped to a config", new Object[0]);
            }
            Map<String, String> configMap = IntStream.range(0, allConfigs.size() / 2).boxed().collect(Collectors.toMap(i -> (String)allConfigs.get(2 * i), i -> (String)allConfigs.get(2 * i + 1)));
            configMap.forEach((clazz, config) -> {
                Capabilities stereotype = (Capabilities)JSON.toType(config, Capabilities.class);
                SessionFactory sessionFactory = this.createSessionFactory((String)clazz, stereotype);
                sessionFactories.put((Object)stereotype, (Object)sessionFactory);
            });
        });
    }

    private SessionFactory createSessionFactory(String clazz, Capabilities stereotype) {
        LOG.fine(String.format("Creating %s as instance of %s", clazz, SessionFactory.class));
        try {
            Class<?> ClassClazz = Class.forName(clazz, true, Thread.currentThread().getContextClassLoader());
            Method create = ClassClazz.getMethod("create", Config.class, Capabilities.class);
            if (!Modifier.isStatic(create.getModifiers())) {
                throw new IllegalArgumentException(String.format("Class %s's `create(Config, Capabilities)` method must be static", clazz));
            }
            if (!SessionFactory.class.isAssignableFrom(create.getReturnType())) {
                throw new IllegalArgumentException(String.format("Class %s's `create(Config, Capabilities)` method must be static", clazz));
            }
            return (SessionFactory)create.invoke(null, this.config, stereotype);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(String.format("Class %s must have a static `create(Config, Capabilities)` method", clazz));
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalArgumentException("Unable to find class: " + clazz, e);
        }
    }

    private void addDriverConfigs(Function<Capabilities, Collection<SessionFactory>> factoryFactory, ImmutableMultimap.Builder<Capabilities, SessionFactory> sessionFactories) {
        HashMultimap driverConfigs = HashMultimap.create();
        int configElements = 3;
        this.config.getAll(NODE_SECTION, "driver-configuration").ifPresent(arg_0 -> this.lambda$addDriverConfigs$14(configElements, (Multimap)driverConfigs, factoryFactory, arg_0));
        driverConfigs.asMap().entrySet().stream().peek(this::report).forEach(entry -> sessionFactories.putAll((Object)((WebDriverInfo)entry.getKey()).getCanonicalCapabilities(), (Iterable)entry.getValue()));
    }

    private void addDetectedDrivers(Map<WebDriverInfo, Collection<SessionFactory>> allDrivers, ImmutableMultimap.Builder<Capabilities, SessionFactory> sessionFactories) {
        if (!this.config.getBool(NODE_SECTION, "detect-drivers").orElse(true).booleanValue()) {
            return;
        }
        if (this.config.getAll(NODE_SECTION, "drivers").isPresent()) {
            return;
        }
        allDrivers.entrySet().stream().peek(this::report).forEach(entry -> sessionFactories.putAll((Object)((WebDriverInfo)entry.getKey()).getCanonicalCapabilities(), (Iterable)entry.getValue()));
    }

    private void addSpecificDrivers(Map<WebDriverInfo, Collection<SessionFactory>> allDrivers, ImmutableMultimap.Builder<Capabilities, SessionFactory> sessionFactories) {
        if (!this.config.getBool(NODE_SECTION, "detect-drivers").orElse(true).booleanValue() && this.config.getAll(NODE_SECTION, "drivers").isPresent()) {
            String logMessage = "Specific drivers cannot be added if 'detect-drivers' is set to false";
            LOG.warning(logMessage);
            throw new ConfigException(logMessage, new Object[0]);
        }
        List drivers = ((List)this.config.getAll(NODE_SECTION, "drivers").orElse(new ArrayList())).stream().map(String::toLowerCase).collect(Collectors.toList());
        allDrivers.entrySet().stream().filter(entry -> drivers.contains(((WebDriverInfo)entry.getKey()).getDisplayName().toLowerCase())).sorted(Comparator.comparing(entry -> ((WebDriverInfo)entry.getKey()).getDisplayName().toLowerCase())).peek(this::report).forEach(entry -> sessionFactories.putAll((Object)((WebDriverInfo)entry.getKey()).getCanonicalCapabilities(), (Iterable)entry.getValue()));
    }

    private Map<WebDriverInfo, Collection<SessionFactory>> discoverDrivers(int maxSessions, Function<Capabilities, Collection<SessionFactory>> factoryFactory) {
        if (!this.config.getBool(NODE_SECTION, "detect-drivers").orElse(true).booleanValue()) {
            return ImmutableMap.of();
        }
        List<WebDriverInfo> infos = StreamSupport.stream(ServiceLoader.load(WebDriverInfo.class).spliterator(), false).filter(WebDriverInfo::isAvailable).sorted(Comparator.comparing(info -> info.getDisplayName().toLowerCase())).collect(Collectors.toList());
        ArrayList builders = new ArrayList();
        ServiceLoader.load(DriverService.Builder.class).forEach(builders::add);
        HashMultimap toReturn = HashMultimap.create();
        infos.forEach(arg_0 -> NodeOptions.lambda$discoverDrivers$23(builders, maxSessions, (Multimap)toReturn, factoryFactory, arg_0));
        return toReturn.asMap();
    }

    private WebDriverInfo createConfiguredDriverInfo(final WebDriverInfo detectedDriver, final Capabilities canonicalCapabilities, final String displayName) {
        return new WebDriverInfo(){

            public String getDisplayName() {
                return displayName;
            }

            public Capabilities getCanonicalCapabilities() {
                return canonicalCapabilities;
            }

            public boolean isSupporting(Capabilities capabilities) {
                return detectedDriver.isSupporting(capabilities);
            }

            public boolean isSupportingCdp() {
                return detectedDriver.isSupportingCdp();
            }

            public boolean isAvailable() {
                return detectedDriver.isAvailable();
            }

            public int getMaximumSimultaneousSessions() {
                return detectedDriver.getMaximumSimultaneousSessions();
            }

            public Optional<WebDriver> createDriver(Capabilities capabilities) throws SessionNotCreatedException {
                return Optional.empty();
            }
        };
    }

    private void report(Map.Entry<WebDriverInfo, Collection<SessionFactory>> entry) {
        StringBuilder caps = new StringBuilder();
        try (JsonOutput out = JSON.newOutput((Appendable)caps);){
            out.setPrettyPrint(false);
            out.write((Object)entry.getKey().getCanonicalCapabilities());
        }
        LOG.info(String.format("Adding %s for %s %d times", entry.getKey().getDisplayName(), caps.toString().replaceAll("\\s+", " "), entry.getValue().size()));
    }

    private static /* synthetic */ void lambda$discoverDrivers$23(List builders, int maxSessions, Multimap toReturn, Function factoryFactory, WebDriverInfo info) {
        Capabilities caps = info.getCanonicalCapabilities();
        builders.stream().filter(builder -> builder.score(caps) > 0).forEach(builder -> {
            for (int i = 0; i < Math.min(info.getMaximumSimultaneousSessions(), maxSessions); ++i) {
                toReturn.putAll((Object)info, (Iterable)factoryFactory.apply(caps));
            }
        });
    }

    private /* synthetic */ void lambda$addDriverConfigs$14(int configElements, Multimap driverConfigs, Function factoryFactory, List drivers) {
        if (drivers.size() % configElements != 0) {
            throw new ConfigException("Expected each driver config to have three elements (name, stereotype and max-sessions)", new Object[0]);
        }
        drivers.stream().filter(driver -> !driver.contains("=")).peek(driver -> LOG.warning(driver + " does not have the required 'key=value' structure for the configuration")).findFirst().ifPresent(ignore -> {
            throw new ConfigException("One or more driver configs does not have the required 'key=value' structure", new Object[0]);
        });
        ArrayList driversMap = new ArrayList();
        IntStream.range(0, drivers.size() / configElements).boxed().forEach(i -> {
            ImmutableMap configMap = ImmutableMap.of((Object)((String)drivers.get(i * configElements)).split("=")[0], (Object)((String)drivers.get(i * configElements)).split("=")[1], (Object)((String)drivers.get(i * configElements + 1)).split("=")[0], (Object)((String)drivers.get(i * configElements + 1)).split("=")[1], (Object)((String)drivers.get(i * configElements + 2)).split("=")[0], (Object)((String)drivers.get(i * configElements + 2)).split("=")[1]);
            driversMap.add(configMap);
        });
        ArrayList builders = new ArrayList();
        ServiceLoader.load(DriverService.Builder.class).forEach(builders::add);
        ArrayList infos = new ArrayList();
        ServiceLoader.load(WebDriverInfo.class).forEach(infos::add);
        driversMap.forEach(configMap -> {
            if (!configMap.containsKey("stereotype")) {
                throw new ConfigException("Driver config is missing stereotype value. " + configMap, new Object[0]);
            }
            Capabilities stereotype = (Capabilities)JSON.toType((String)configMap.get("stereotype"), Capabilities.class);
            String configName = configMap.getOrDefault("name", "Custom Slot Config");
            int driverMaxSessions = Integer.parseInt(configMap.getOrDefault("max-sessions", "1"));
            Require.positive((String)"Driver max sessions", (Integer)driverMaxSessions);
            WebDriverInfo info = infos.stream().filter(webDriverInfo -> webDriverInfo.isSupporting(stereotype)).findFirst().orElseThrow(() -> new ConfigException("Unable to find matching driver for %s", stereotype));
            WebDriverInfo driverInfoConfig = this.createConfiguredDriverInfo(info, stereotype, configName);
            builders.stream().filter(builder -> builder.score(stereotype) > 0).forEach(builder -> {
                int maxSessions = Math.min(info.getMaximumSimultaneousSessions(), driverMaxSessions);
                for (int i = 0; i < maxSessions; ++i) {
                    driverConfigs.putAll((Object)driverInfoConfig, (Iterable)factoryFactory.apply(stereotype));
                }
            });
        });
    }
}

