/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.config;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.openqa.selenium.grid.config.Config;
import org.openqa.selenium.grid.config.ConfigException;
import org.openqa.selenium.internal.Require;

public class CompoundConfig
implements Config {
    private final List<Config> allConfigs;

    public CompoundConfig(Config ... allConfigsInDescendingOrderOfImportance) {
        if (allConfigsInDescendingOrderOfImportance.length == 0) {
            throw new ConfigException("List of config files must be greater than 0.", new Object[0]);
        }
        this.allConfigs = ImmutableList.copyOf((Object[])allConfigsInDescendingOrderOfImportance);
    }

    @Override
    public Optional<List<String>> getAll(String section, String option) {
        Require.nonNull((String)"Section name", (Object)section);
        Require.nonNull((String)"Option name", (Object)option);
        List values = (List)this.allConfigs.stream().map(config -> config.getAll(section, option)).filter(Optional::isPresent).map(Optional::get).flatMap(Collection::stream).collect(ImmutableList.toImmutableList());
        return values.isEmpty() ? Optional.empty() : Optional.of(values);
    }

    @Override
    public Set<String> getSectionNames() {
        return (Set)this.allConfigs.stream().map(Config::getSectionNames).flatMap(Collection::stream).collect(ImmutableSortedSet.toImmutableSortedSet(Comparator.naturalOrder()));
    }

    @Override
    public Set<String> getOptions(String section) {
        Require.nonNull((String)"Section name to get options for", (Object)section);
        return (Set)this.allConfigs.stream().map(config -> config.getOptions(section)).flatMap(Collection::stream).collect(ImmutableSortedSet.toImmutableSortedSet(Comparator.naturalOrder()));
    }
}

