/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.netty.server;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpServerKeepAliveHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.stream.ChunkedWriteHandler;
import java.util.Objects;
import org.openqa.selenium.netty.server.RequestConverter;
import org.openqa.selenium.netty.server.ResponseConverter;
import org.openqa.selenium.netty.server.SeleniumHandler;
import org.openqa.selenium.remote.http.HttpHandler;

class SeleniumHttpInitializer
extends ChannelInitializer<SocketChannel> {
    private HttpHandler seleniumHandler;
    private SslContext sslCtx;

    SeleniumHttpInitializer(HttpHandler seleniumHandler, SslContext sslCtx) {
        this.seleniumHandler = Objects.requireNonNull(seleniumHandler);
        this.sslCtx = sslCtx;
    }

    protected void initChannel(SocketChannel ch) {
        if (this.sslCtx != null) {
            ch.pipeline().addLast("ssl", (ChannelHandler)this.sslCtx.newHandler(ch.alloc()));
        }
        ch.pipeline().addLast("codec", (ChannelHandler)new HttpServerCodec());
        ch.pipeline().addLast("keep-alive", (ChannelHandler)new HttpServerKeepAliveHandler());
        ch.pipeline().addLast("chunked-write", (ChannelHandler)new ChunkedWriteHandler());
        ch.pipeline().addLast("se-request", (ChannelHandler)new RequestConverter());
        ch.pipeline().addLast("se-response", (ChannelHandler)new ResponseConverter());
        ch.pipeline().addLast("se-handler", (ChannelHandler)new SeleniumHandler(this.seleniumHandler));
    }
}

