/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.web;

import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.lang.reflect.Type;
import java.util.Map;
import org.openqa.selenium.grid.web.ErrorCodec;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.json.JsonInput;
import org.openqa.selenium.json.JsonType;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpMessage;
import org.openqa.selenium.remote.http.HttpResponse;

public class Values {
    private static final Json JSON = new Json();
    private static final ErrorCodec ERRORS = ErrorCodec.createDefault();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T get(HttpResponse response, Type typeOfT) {
        try (Reader reader = Contents.reader((HttpMessage)response);
             JsonInput input = JSON.newInput(reader);){
            if (response.getStatus() != 200) {
                throw ERRORS.decode((Map)JSON.toType(Contents.string((HttpMessage)response), Json.MAP_TYPE));
            }
            if (Void.class.equals((Object)typeOfT) && input.peek() == JsonType.END) {
                T t = null;
                return t;
            }
            input.beginObject();
            while (input.hasNext()) {
                if ("value".equals(input.nextName())) {
                    Object object = input.read(typeOfT);
                    return (T)object;
                }
                input.skipValue();
            }
            throw new IllegalStateException("Unable to locate value: " + Contents.string((HttpMessage)response));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

