/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.sessionmap;

import com.google.common.collect.ImmutableMap;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.tag.Tags;
import java.util.Objects;
import org.openqa.selenium.grid.data.Session;
import org.openqa.selenium.grid.sessionmap.SessionMap;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.tracing.HttpTracing;

class GetFromSessionMap
implements HttpHandler {
    private final Tracer tracer;
    private final Json json;
    private final SessionMap sessions;
    private final SessionId id;

    public GetFromSessionMap(Tracer tracer, Json json, SessionMap sessions, SessionId id) {
        this.tracer = Objects.requireNonNull(tracer);
        this.json = Objects.requireNonNull(json);
        this.sessions = Objects.requireNonNull(sessions);
        this.id = Objects.requireNonNull(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpResponse execute(HttpRequest req) {
        SpanContext parent = HttpTracing.extract((Tracer)this.tracer, (HttpRequest)req);
        Span current = this.tracer.scopeManager().activeSpan();
        Span span = this.tracer.buildSpan("sessions.get_session").asChildOf(parent).start();
        this.tracer.scopeManager().activate(span);
        try {
            Tags.HTTP_METHOD.set(span, req.getMethod().toString());
            Tags.HTTP_URL.set(span, req.getUri());
            Session session = this.sessions.get(this.id);
            span.setTag("session.id", session.getId().toString());
            span.setTag("session.capabilities", session.getCapabilities().toString());
            span.setTag("session.uri", session.getUri().toString());
            HttpResponse httpResponse = (HttpResponse)new HttpResponse().setContent(Contents.utf8String((CharSequence)this.json.toJson((Object)ImmutableMap.of((Object)"value", (Object)session))));
            return httpResponse;
        }
        finally {
            span.finish();
            this.tracer.scopeManager().activate(current);
        }
    }
}

