/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.node.httpd;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterException;
import io.opentracing.Tracer;
import java.time.Duration;
import java.util.logging.Logger;
import org.openqa.selenium.BuildInfo;
import org.openqa.selenium.cli.CliCommand;
import org.openqa.selenium.concurrent.Regularly;
import org.openqa.selenium.events.EventBus;
import org.openqa.selenium.grid.component.HealthCheck;
import org.openqa.selenium.grid.config.AnnotatedConfig;
import org.openqa.selenium.grid.config.CompoundConfig;
import org.openqa.selenium.grid.config.ConcatenatingConfig;
import org.openqa.selenium.grid.config.EnvConfig;
import org.openqa.selenium.grid.data.NodeStatusEvent;
import org.openqa.selenium.grid.docker.DockerFlags;
import org.openqa.selenium.grid.docker.DockerOptions;
import org.openqa.selenium.grid.log.LoggingOptions;
import org.openqa.selenium.grid.node.config.NodeOptions;
import org.openqa.selenium.grid.node.httpd.DefaultNodeConfig;
import org.openqa.selenium.grid.node.httpd.NodeFlags;
import org.openqa.selenium.grid.node.local.LocalNode;
import org.openqa.selenium.grid.server.BaseServerFlags;
import org.openqa.selenium.grid.server.BaseServerOptions;
import org.openqa.selenium.grid.server.EventBusFlags;
import org.openqa.selenium.grid.server.EventBusOptions;
import org.openqa.selenium.grid.server.HelpFlags;
import org.openqa.selenium.netty.server.NettyServer;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.tracing.TracedHttpClient;

public class NodeServer
implements CliCommand {
    private static final Logger LOG = Logger.getLogger(NodeServer.class.getName());

    @Override
    public String getName() {
        return "node";
    }

    @Override
    public String getDescription() {
        return "Adds this server as a node in the selenium grid.";
    }

    @Override
    public CliCommand.Executable configure(String ... args) {
        HelpFlags help = new HelpFlags();
        BaseServerFlags serverFlags = new BaseServerFlags(5555);
        EventBusFlags eventBusFlags = new EventBusFlags();
        NodeFlags nodeFlags = new NodeFlags();
        DockerFlags dockerFlags = new DockerFlags();
        JCommander commander = JCommander.newBuilder().programName(this.getName()).addObject((Object)help).addObject((Object)serverFlags).addObject((Object)eventBusFlags).addObject((Object)dockerFlags).addObject((Object)nodeFlags).build();
        return () -> {
            try {
                commander.parse(args);
            }
            catch (ParameterException e) {
                System.err.println(e.getMessage());
                commander.usage();
                return;
            }
            if (help.displayHelp(commander, System.out)) {
                return;
            }
            CompoundConfig config = new CompoundConfig(new EnvConfig(), new ConcatenatingConfig("node", '.', System.getProperties()), new AnnotatedConfig(help), new AnnotatedConfig(serverFlags), new AnnotatedConfig(eventBusFlags), new AnnotatedConfig(nodeFlags), new AnnotatedConfig(dockerFlags), new DefaultNodeConfig());
            LoggingOptions loggingOptions = new LoggingOptions(config);
            loggingOptions.configureLogging();
            Tracer tracer = loggingOptions.getTracer();
            EventBusOptions events = new EventBusOptions(config);
            EventBus bus = events.getEventBus();
            TracedHttpClient.Factory clientFactory = new TracedHttpClient.Factory(tracer, HttpClient.Factory.createDefault());
            BaseServerOptions serverOptions = new BaseServerOptions(config);
            LocalNode.Builder builder = LocalNode.builder(tracer, bus, (HttpClient.Factory)clientFactory, serverOptions.getExternalUri());
            new NodeOptions(config).configure(tracer, (HttpClient.Factory)clientFactory, builder);
            new DockerOptions(config).configure(tracer, (HttpClient.Factory)clientFactory, builder);
            LocalNode node = builder.build();
            NettyServer server = new NettyServer(serverOptions, node);
            server.start();
            BuildInfo info = new BuildInfo();
            LOG.info(String.format("Started Selenium node %s (revision %s)", info.getReleaseLabel(), info.getBuildRevision()));
            Regularly regularly = new Regularly("Register Node with Distributor");
            regularly.submit(() -> {
                HealthCheck.Result check = node.getHealthCheck().check();
                if (!check.isAlive()) {
                    LOG.info("Node is not alive: " + check.getMessage());
                    throw new UnsupportedOperationException("Node cannot be registered");
                }
                bus.fire(new NodeStatusEvent(node.getStatus()));
            }, Duration.ofMinutes(5L), Duration.ofSeconds(30L));
        };
    }
}

