/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.node.config;

import io.opentracing.Tracer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriverInfo;
import org.openqa.selenium.grid.config.Config;
import org.openqa.selenium.grid.node.config.DriverServiceSessionFactory;
import org.openqa.selenium.grid.node.local.LocalNode;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.service.DriverService;

public class NodeOptions {
    public static final Logger LOG = Logger.getLogger(NodeOptions.class.getName());
    private final Config config;

    public NodeOptions(Config config) {
        this.config = Objects.requireNonNull(config);
    }

    public void configure(Tracer tracer, HttpClient.Factory httpClientFactory, LocalNode.Builder node) {
        if (!this.config.getBool("node", "detect-drivers").orElse(false).booleanValue()) {
            return;
        }
        this.addSystemDrivers(tracer, httpClientFactory, node);
    }

    private void addSystemDrivers(Tracer tracer, HttpClient.Factory clientFactory, LocalNode.Builder node) {
        List<WebDriverInfo> infos = StreamSupport.stream(ServiceLoader.load(WebDriverInfo.class).spliterator(), false).filter(WebDriverInfo::isAvailable).collect(Collectors.toList());
        ArrayList builders = new ArrayList();
        ServiceLoader.load(DriverService.Builder.class).forEach(builders::add);
        infos.forEach(info -> {
            Capabilities caps = info.getCanonicalCapabilities();
            builders.stream().filter(builder -> builder.score(caps) > 0).peek(builder -> LOG.info(String.format("Adding %s %d times", caps, info.getMaximumSimultaneousSessions()))).forEach(builder -> {
                DriverService.Builder freePortBuilder = builder.usingAnyFreePort();
                for (int i = 0; i < info.getMaximumSimultaneousSessions(); ++i) {
                    node.add(caps, new DriverServiceSessionFactory(tracer, clientFactory, c -> freePortBuilder.score(c) > 0, freePortBuilder));
                }
            });
        });
    }
}

