/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.node;

import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Map;
import java.util.Objects;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.grid.node.Node;
import org.openqa.selenium.io.TemporaryFilesystem;
import org.openqa.selenium.io.Zip;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpMessage;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;

class UploadFile
implements HttpHandler {
    private final Node node;
    private final Json json;

    UploadFile(Node node, Json json) {
        this.node = Objects.requireNonNull(node);
        this.json = Objects.requireNonNull(json);
    }

    public HttpResponse execute(HttpRequest req) throws UncheckedIOException {
        Map incoming = (Map)this.json.toType(Contents.string((HttpMessage)req), Json.MAP_TYPE);
        TemporaryFilesystem tempfs = TemporaryFilesystem.getDefaultTmpFS();
        File tempDir = tempfs.createTempDir("upload", "file");
        try {
            Zip.unzip((String)((String)incoming.get("file")), (File)tempDir);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        File[] allFiles = tempDir.listFiles();
        if (allFiles == null) {
            throw new WebDriverException(String.format("Cannot access temporary directory for uploaded files %s", tempDir));
        }
        if (allFiles.length != 1) {
            throw new WebDriverException(String.format("Expected there to be only 1 file. There were: %s", allFiles.length));
        }
        ImmutableMap result = ImmutableMap.of((Object)"value", (Object)allFiles[0].getAbsolutePath());
        return (HttpResponse)new HttpResponse().setContent(Contents.utf8String((CharSequence)this.json.toJson((Object)result)));
    }
}

