/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.log;

import java.io.OutputStream;
import java.util.Objects;
import java.util.logging.LogRecord;
import java.util.logging.StreamHandler;

class FlushingHandler
extends StreamHandler {
    private OutputStream out;

    FlushingHandler(OutputStream out) {
        this.setOutputStream(out);
    }

    @Override
    protected synchronized void setOutputStream(OutputStream out) throws SecurityException {
        super.setOutputStream(out);
        this.out = out;
    }

    @Override
    public synchronized void publish(LogRecord record) {
        super.publish(record);
        this.flush();
    }

    @Override
    public synchronized void close() throws SecurityException {
        if (Objects.equals(System.out, this.out) || Objects.equals(System.err, this.out)) {
            this.flush();
        } else {
            super.close();
        }
    }
}

