/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.config;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.grid.config.Config;

public class MapConfig
implements Config {
    private final Map<String, Object> raw;

    public MapConfig(Map<String, Object> raw) {
        this.raw = raw;
    }

    @Override
    public Optional<List<String>> getAll(String section, String option) {
        Objects.requireNonNull(section, "Section name not set");
        Objects.requireNonNull(option, "Option name not set");
        Object rawSection = this.raw.get(section);
        if (!(rawSection instanceof Map)) {
            return Optional.empty();
        }
        Object value = ((Map)rawSection).get(option);
        return value == null ? Optional.empty() : Optional.of(ImmutableList.of((Object)String.valueOf(value)));
    }
}

