/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid;

import java.io.File;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openqa.selenium.cli.CliCommand;
import org.openqa.selenium.cli.WrappedPrintWriter;

public class Main {
    private static final Logger LOG = Logger.getLogger(Main.class.getName());

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            new Help(Main.loadCommands(Main.class.getClassLoader())).configure(new String[0]).run();
        } else if ("--ext".equals(args[0])) {
            if (args.length > 1) {
                StringTokenizer tokenizer = new StringTokenizer(args[1], File.pathSeparator);
                ArrayList<File> jars = new ArrayList<File>();
                while (tokenizer.hasMoreTokens()) {
                    File file2 = new File(tokenizer.nextToken());
                    if (file2.exists()) {
                        if (file2.isDirectory()) {
                            for (File subdirFile : file2.listFiles()) {
                                if (!subdirFile.isFile() || !subdirFile.getName().endsWith(".jar")) continue;
                                jars.add(subdirFile);
                            }
                            continue;
                        }
                        jars.add(file2);
                        continue;
                    }
                    System.err.println("WARNING: Extension file or directory does not exist: " + file2);
                }
                URL[] jarUrls = (URL[])jars.stream().map(file -> {
                    try {
                        return file.toURI().toURL();
                    }
                    catch (MalformedURLException e) {
                        LOG.log(Level.SEVERE, "Unable to find JAR file " + file, e);
                        throw new UncheckedIOException(e);
                    }
                }).toArray(URL[]::new);
                URLClassLoader loader = AccessController.doPrivileged(() -> new URLClassLoader(jarUrls, Main.class.getClassLoader()));
                Thread.currentThread().setContextClassLoader(loader);
                if (args.length > 2) {
                    String[] remainingArgs = new String[args.length - 2];
                    System.arraycopy(args, 2, remainingArgs, 0, args.length - 2);
                    Main.launch(remainingArgs, loader);
                } else {
                    new Help(Main.loadCommands(loader)).configure(new String[0]).run();
                }
            } else {
                new Help(Main.loadCommands(Main.class.getClassLoader())).configure(new String[0]).run();
            }
        } else {
            Main.launch(args, Main.class.getClassLoader());
        }
    }

    private static Set<CliCommand> loadCommands(ClassLoader loader) {
        TreeSet<CliCommand> commands = new TreeSet<CliCommand>(Comparator.comparing(CliCommand::getName));
        ServiceLoader.load(CliCommand.class, loader).forEach(commands::add);
        return commands;
    }

    private static void launch(String[] args, ClassLoader loader) throws Exception {
        String commandName = args[0];
        String[] remainingArgs = new String[args.length - 1];
        System.arraycopy(args, 1, remainingArgs, 0, args.length - 1);
        Set<CliCommand> commands = Main.loadCommands(loader);
        CliCommand command = commands.parallelStream().filter(cmd -> commandName.equals(cmd.getName())).findFirst().orElse(new Help(commands));
        command.configure(remainingArgs).run();
    }

    private static class Help
    implements CliCommand {
        private final Set<CliCommand> commands;

        public Help(Set<CliCommand> commands) {
            this.commands = commands;
        }

        @Override
        public String getName() {
            return "Selenium Server commands";
        }

        @Override
        public String getDescription() {
            return "A list of all the commands available. To use one, run `java -jar selenium.jar commandName`.";
        }

        @Override
        public CliCommand.Executable configure(String ... args) {
            return () -> {
                int longest = this.commands.stream().map(CliCommand::getName).max(Comparator.comparingInt(String::length)).map(String::length).orElse(0) + 2;
                WrappedPrintWriter out = new WrappedPrintWriter((OutputStream)System.out, 72, 0);
                out.append(this.getName()).append("\n\n");
                out.append(this.getDescription()).append("\n").append("\n");
                int indent = Math.min(longest + 2, 25);
                String format = "  %-" + longest + "s";
                WrappedPrintWriter indented = new WrappedPrintWriter((OutputStream)System.out, 72, indent);
                this.commands.forEach(cmd -> indented.format(format, cmd.getName()).append(cmd.getDescription()).append("\n"));
                out.write("\nFor each command, run with `--help` for command-specific help\n");
                out.write("\nUse the `--ext` flag before the command name to specify an additional classpath to use with the server (for example, to provide additional commands, or to provide additional driver implementations). For example:\n");
                out.write(String.format("\n  java -jar selenium.jar --ext example.jar%sdir standalone --port 1234", File.pathSeparator));
                System.out.println("\n");
            };
        }
    }
}

