/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.node.remote;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.NoSuchSessionException;
import org.openqa.selenium.grid.component.HealthCheck;
import org.openqa.selenium.grid.data.CreateSessionRequest;
import org.openqa.selenium.grid.data.CreateSessionResponse;
import org.openqa.selenium.grid.data.NodeStatus;
import org.openqa.selenium.grid.data.Session;
import org.openqa.selenium.grid.node.Node;
import org.openqa.selenium.grid.web.Values;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.net.Urls;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpMessage;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;

public class RemoteNode
extends Node {
    public static final Json JSON = new Json();
    private final HttpHandler client;
    private final URI externalUri;
    private final Set<Capabilities> capabilities;
    private final HealthCheck healthCheck;

    public RemoteNode(HttpClient.Factory clientFactory, UUID id, URI externalUri, Collection<Capabilities> capabilities) {
        super(id, externalUri);
        this.externalUri = Objects.requireNonNull(externalUri);
        this.capabilities = ImmutableSet.copyOf(capabilities);
        this.client = Objects.requireNonNull(clientFactory).createClient(Urls.fromUri((URI)externalUri));
        this.healthCheck = new RemoteCheck();
    }

    @Override
    public boolean isSupporting(Capabilities capabilities) {
        return this.capabilities.stream().anyMatch(caps -> caps.getCapabilityNames().stream().allMatch(name -> Objects.equals(caps.getCapability(name), capabilities.getCapability(name))));
    }

    @Override
    public Optional<CreateSessionResponse> newSession(CreateSessionRequest sessionRequest) {
        Objects.requireNonNull(sessionRequest, "Capabilities for session are not set");
        HttpRequest req = new HttpRequest(HttpMethod.POST, "/se/grid/node/session");
        req.setContent(Contents.utf8String((CharSequence)JSON.toJson((Object)sessionRequest)));
        HttpResponse res = this.client.execute(req);
        return Optional.ofNullable((CreateSessionResponse)Values.get(res, CreateSessionResponse.class));
    }

    @Override
    protected boolean isSessionOwner(SessionId id) {
        Objects.requireNonNull(id, "Session ID has not been set");
        HttpRequest req = new HttpRequest(HttpMethod.GET, "/se/grid/node/owner/" + id);
        HttpResponse res = this.client.execute(req);
        return Values.get(res, Boolean.class) == Boolean.TRUE;
    }

    @Override
    public Session getSession(SessionId id) throws NoSuchSessionException {
        Objects.requireNonNull(id, "Session ID has not been set");
        HttpRequest req = new HttpRequest(HttpMethod.GET, "/se/grid/node/session/" + id);
        HttpResponse res = this.client.execute(req);
        return (Session)Values.get(res, Session.class);
    }

    @Override
    public HttpResponse executeWebDriverCommand(HttpRequest req) {
        return this.client.execute(req);
    }

    @Override
    public void stop(SessionId id) throws NoSuchSessionException {
        Objects.requireNonNull(id, "Session ID has not been set");
        HttpRequest req = new HttpRequest(HttpMethod.DELETE, "/se/grid/node/session/" + id);
        HttpResponse res = this.client.execute(req);
        Values.get(res, Void.class);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public NodeStatus getStatus() {
        req = new HttpRequest(HttpMethod.GET, "/status");
        res = this.client.execute(req);
        try {
            block20: {
                reader = Contents.reader((HttpMessage)res);
                in = RemoteNode.JSON.newInput(reader);
                in.beginObject();
lbl9:
                // 2 sources

                while (true) {
                    if (in.hasNext() == false) throw new IllegalStateException("Unable to read status");
                    if ("value".equals(in.nextName())) {
                        in.beginObject();
                        break block20;
                    }
                    in.skipValue();
                    continue;
                    break;
                }
                finally {
                    if (in != null) {
                        in.close();
                    }
                }
                finally {
                    if (reader != null) {
                        reader.close();
                    }
                }
            }
            while (in.hasNext()) {
                if ("node".equals(in.nextName())) {
                    var5_7 = (NodeStatus)in.read(NodeStatus.class);
                    return var5_7;
                }
                in.skipValue();
            }
            in.endObject();
            ** continue;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public HealthCheck getHealthCheck() {
        return this.healthCheck;
    }

    private Map<String, Object> toJson() {
        return ImmutableMap.of((Object)"id", (Object)this.getId(), (Object)"uri", (Object)this.externalUri, (Object)"capabilities", this.capabilities);
    }

    private class RemoteCheck
    implements HealthCheck {
        private RemoteCheck() {
        }

        @Override
        public HealthCheck.Result check() {
            HttpRequest req = new HttpRequest(HttpMethod.GET, "/status");
            try {
                HttpResponse res = RemoteNode.this.client.execute(req);
                if (res.getStatus() == 200) {
                    return new HealthCheck.Result(true, RemoteNode.this.externalUri + " is ok");
                }
                return new HealthCheck.Result(false, String.format("An error occurred reading the status of %s: %s", RemoteNode.this.externalUri, Contents.string((HttpMessage)res)));
            }
            catch (RuntimeException e) {
                return new HealthCheck.Result(false, "Unable to determine node status: " + e.getMessage());
            }
        }
    }
}

