/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.docker;

import com.google.common.collect.ImmutableList;
import com.google.common.reflect.TypeToken;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.logging.Logger;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.docker.Container;
import org.openqa.selenium.docker.ContainerId;
import org.openqa.selenium.docker.ContainerInfo;
import org.openqa.selenium.docker.DockerException;
import org.openqa.selenium.docker.Image;
import org.openqa.selenium.docker.ImageNamePredicate;
import org.openqa.selenium.docker.ImageSummary;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.json.JsonException;
import org.openqa.selenium.json.JsonOutput;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpMessage;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;

public class Docker {
    private static final Logger LOG = Logger.getLogger(Docker.class.getName());
    private static final Json JSON = new Json();
    private final HttpHandler client;

    public Docker(HttpHandler client) {
        Objects.requireNonNull(client, "Docker HTTP client must be set.");
        this.client = req -> {
            HttpResponse resp = client.execute(req);
            if (resp.getStatus() < 200 && resp.getStatus() > 200) {
                String value = Contents.string((HttpMessage)resp);
                try {
                    Object obj = JSON.toType(value, Object.class);
                    if (obj instanceof Map) {
                        Map map = (Map)obj;
                        String message = map.get("message") instanceof String ? (String)map.get("message") : value;
                        throw new RuntimeException(message);
                    }
                    throw new RuntimeException(value);
                }
                catch (JsonException e) {
                    throw new RuntimeException(value);
                }
            }
            return resp;
        };
    }

    public Image pull(String name, String tag) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(tag);
        this.findImage(new ImageNamePredicate(name, tag));
        LOG.info(String.format("Pulling %s:%s", name, tag));
        HttpRequest request = new HttpRequest(HttpMethod.POST, "/images/create").addQueryParameter("fromImage", name).addQueryParameter("tag", tag);
        HttpResponse res = this.client.execute(request);
        if (res.getStatus() != 200) {
            throw new WebDriverException("Unable to pull container: " + name);
        }
        LOG.info(String.format("Pull of %s:%s complete", name, tag));
        return this.findImage(new ImageNamePredicate(name, tag)).orElseThrow(() -> new DockerException(String.format("Cannot find image matching: %s:%s", name, tag)));
    }

    public List<Image> listImages() {
        LOG.fine("Listing images");
        HttpResponse response = this.client.execute(new HttpRequest(HttpMethod.GET, "/images/json"));
        List images = (List)JSON.toType(Contents.string((HttpMessage)response), new TypeToken<List<ImageSummary>>(){}.getType());
        return (List)images.stream().map(Image::new).collect(ImmutableList.toImmutableList());
    }

    public Optional<Image> findImage(Predicate<Image> filter) {
        Objects.requireNonNull(filter);
        LOG.fine("Finding image: " + filter);
        return this.listImages().stream().filter(filter).findFirst();
    }

    public Container create(ContainerInfo info) {
        StringBuilder json = new StringBuilder();
        try (JsonOutput output = JSON.newOutput((Appendable)json);){
            output.setPrettyPrint(false);
            output.write((Object)info);
        }
        LOG.info("Creating container: " + json);
        HttpRequest request = new HttpRequest(HttpMethod.POST, "/containers/create");
        request.setContent(Contents.utf8String((CharSequence)json));
        HttpResponse response = this.client.execute(request);
        Map toRead = (Map)JSON.toType(Contents.string((HttpMessage)response), Json.MAP_TYPE);
        return new Container(this.client, new ContainerId((String)toRead.get("Id")));
    }
}

