/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.firefox;

import java.util.HashMap;
import java.util.Map;
import org.openqa.selenium.firefox.FirefoxProfile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Preferences {
    private Map<String, String> additionalPrefs = new HashMap<String, String>();

    Preferences() {
    }

    public void setPreference(String key, String value) {
        if (this.isStringified(value)) {
            throw new IllegalArgumentException(String.format("Preference values must be plain strings: %s: %s", key, value));
        }
        this.additionalPrefs.put(key, String.format("\"%s\"", value));
    }

    public void setPreference(String key, boolean value) {
        this.additionalPrefs.put(key, String.valueOf(value));
    }

    public void setPreference(String key, int value) {
        this.additionalPrefs.put(key, String.valueOf(value));
    }

    public void addTo(Map<String, String> prefs) {
        prefs.putAll(this.additionalPrefs);
    }

    public void addTo(FirefoxProfile profile) {
        profile.getAdditionalPreferences().additionalPrefs.putAll(this.additionalPrefs);
    }

    protected Object getPreference(String key) {
        return this.additionalPrefs.get(key);
    }

    private boolean isStringified(String value) {
        return value.startsWith("\"") && value.endsWith("\"");
    }
}

