/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.edge;

import com.google.common.base.Preconditions;
import com.google.gson.JsonObject;
import java.io.IOException;
import org.openqa.selenium.remote.DesiredCapabilities;

public class EdgeOptions {
    public static final String CAPABILITY = "edgeOptions";
    private String pageLoadStrategy;

    public void setPageLoadStrategy(String strategy) {
        this.pageLoadStrategy = (String)Preconditions.checkNotNull((Object)strategy);
    }

    public JsonObject toJson() throws IOException {
        JsonObject options = new JsonObject();
        if (this.pageLoadStrategy != null) {
            options.addProperty("pageLoadStrategy", this.pageLoadStrategy);
        }
        return options;
    }

    DesiredCapabilities toCapabilities() {
        DesiredCapabilities capabilities = DesiredCapabilities.edge();
        if (this.pageLoadStrategy != null) {
            capabilities.setCapability("pageLoadStrategy", this.pageLoadStrategy);
        }
        return capabilities;
    }
}

