/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.database;

import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.database.model.DatabaseId;
import org.openqa.selenium.devtools.database.model.Error;
import org.openqa.selenium.json.JsonInput;

@Beta
public class Database {
    public static Command<Void> disable() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("Database.disable", (Map<String, Object>)params.build());
    }

    public static Command<Void> enable() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("Database.enable", (Map<String, Object>)params.build());
    }

    public static Command<ExecuteSQLResponse> executeSQL(DatabaseId databaseId, String query) {
        Objects.requireNonNull(databaseId, "databaseId is required");
        Objects.requireNonNull(query, "query is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"databaseId", (Object)databaseId);
        params.put((Object)"query", (Object)query);
        return new Command<ExecuteSQLResponse>("Database.executeSQL", (Map<String, Object>)params.build(), input -> (ExecuteSQLResponse)input.read(ExecuteSQLResponse.class));
    }

    public static Command<List<String>> getDatabaseTableNames(DatabaseId databaseId) {
        Objects.requireNonNull(databaseId, "databaseId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"databaseId", (Object)databaseId);
        return new Command<List<String>>("Database.getDatabaseTableNames", (Map<String, Object>)params.build(), ConverterFunctions.map("tableNames", new TypeToken<List<String>>(){}.getType()));
    }

    public static Event<org.openqa.selenium.devtools.database.model.Database> addDatabase() {
        return new Event<org.openqa.selenium.devtools.database.model.Database>("Database.addDatabase", ConverterFunctions.map("database", org.openqa.selenium.devtools.database.model.Database.class));
    }

    public static class ExecuteSQLResponse {
        private final Optional<List<String>> columnNames;
        private final Optional<List<Map<String, Object>>> values;
        private final Optional<Error> sqlError;

        public ExecuteSQLResponse(Optional<List<String>> columnNames, Optional<List<Map<String, Object>>> values, Optional<Error> sqlError) {
            this.columnNames = columnNames;
            this.values = values;
            this.sqlError = sqlError;
        }

        public Optional<List<String>> getColumnNames() {
            return this.columnNames;
        }

        public Optional<List<Map<String, Object>>> getValues() {
            return this.values;
        }

        public Optional<Error> getSqlError() {
            return this.sqlError;
        }

        private static ExecuteSQLResponse fromJson(JsonInput input) {
            Optional<List<String>> columnNames = Optional.empty();
            Optional<List<Map<String, Object>>> values = Optional.empty();
            Optional<Error> sqlError = Optional.empty();
            input.beginObject();
            block10: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "columnNames": {
                        columnNames = Optional.ofNullable((List)input.read(new TypeToken<List<String>>(){}.getType()));
                        continue block10;
                    }
                    case "values": {
                        values = Optional.ofNullable((List)input.read(new TypeToken<List<Map<String, Object>>>(){}.getType()));
                        continue block10;
                    }
                    case "sqlError": {
                        sqlError = Optional.ofNullable((Error)input.read(Error.class));
                        continue block10;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new ExecuteSQLResponse(columnNames, values, sqlError);
        }
    }
}

