package org.openqa.selenium.devtools.overlay.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Configuration data for the highlighting of page elements.
 */
public class HighlightConfig {

    private final java.util.Optional<java.lang.Boolean> showInfo;

    private final java.util.Optional<java.lang.Boolean> showStyles;

    private final java.util.Optional<java.lang.Boolean> showRulers;

    private final java.util.Optional<java.lang.Boolean> showExtensionLines;

    private final java.util.Optional<org.openqa.selenium.devtools.dom.model.RGBA> contentColor;

    private final java.util.Optional<org.openqa.selenium.devtools.dom.model.RGBA> paddingColor;

    private final java.util.Optional<org.openqa.selenium.devtools.dom.model.RGBA> borderColor;

    private final java.util.Optional<org.openqa.selenium.devtools.dom.model.RGBA> marginColor;

    private final java.util.Optional<org.openqa.selenium.devtools.dom.model.RGBA> eventTargetColor;

    private final java.util.Optional<org.openqa.selenium.devtools.dom.model.RGBA> shapeColor;

    private final java.util.Optional<org.openqa.selenium.devtools.dom.model.RGBA> shapeMarginColor;

    private final java.util.Optional<org.openqa.selenium.devtools.dom.model.RGBA> cssGridColor;

    private final java.util.Optional<org.openqa.selenium.devtools.overlay.model.ColorFormat> colorFormat;

    private final java.util.Optional<org.openqa.selenium.devtools.overlay.model.GridHighlightConfig> gridHighlightConfig;

    public HighlightConfig(java.util.Optional<java.lang.Boolean> showInfo, java.util.Optional<java.lang.Boolean> showStyles, java.util.Optional<java.lang.Boolean> showRulers, java.util.Optional<java.lang.Boolean> showExtensionLines, java.util.Optional<org.openqa.selenium.devtools.dom.model.RGBA> contentColor, java.util.Optional<org.openqa.selenium.devtools.dom.model.RGBA> paddingColor, java.util.Optional<org.openqa.selenium.devtools.dom.model.RGBA> borderColor, java.util.Optional<org.openqa.selenium.devtools.dom.model.RGBA> marginColor, java.util.Optional<org.openqa.selenium.devtools.dom.model.RGBA> eventTargetColor, java.util.Optional<org.openqa.selenium.devtools.dom.model.RGBA> shapeColor, java.util.Optional<org.openqa.selenium.devtools.dom.model.RGBA> shapeMarginColor, java.util.Optional<org.openqa.selenium.devtools.dom.model.RGBA> cssGridColor, java.util.Optional<org.openqa.selenium.devtools.overlay.model.ColorFormat> colorFormat, java.util.Optional<org.openqa.selenium.devtools.overlay.model.GridHighlightConfig> gridHighlightConfig) {
        this.showInfo = showInfo;
        this.showStyles = showStyles;
        this.showRulers = showRulers;
        this.showExtensionLines = showExtensionLines;
        this.contentColor = contentColor;
        this.paddingColor = paddingColor;
        this.borderColor = borderColor;
        this.marginColor = marginColor;
        this.eventTargetColor = eventTargetColor;
        this.shapeColor = shapeColor;
        this.shapeMarginColor = shapeMarginColor;
        this.cssGridColor = cssGridColor;
        this.colorFormat = colorFormat;
        this.gridHighlightConfig = gridHighlightConfig;
    }

    /**
     * Whether the node info tooltip should be shown (default: false).
     */
    public java.util.Optional<java.lang.Boolean> getShowInfo() {
        return showInfo;
    }

    /**
     * Whether the node styles in the tooltip (default: false).
     */
    public java.util.Optional<java.lang.Boolean> getShowStyles() {
        return showStyles;
    }

    /**
     * Whether the rulers should be shown (default: false).
     */
    public java.util.Optional<java.lang.Boolean> getShowRulers() {
        return showRulers;
    }

    /**
     * Whether the extension lines from node to the rulers should be shown (default: false).
     */
    public java.util.Optional<java.lang.Boolean> getShowExtensionLines() {
        return showExtensionLines;
    }

    /**
     * The content box highlight fill color (default: transparent).
     */
    public java.util.Optional<org.openqa.selenium.devtools.dom.model.RGBA> getContentColor() {
        return contentColor;
    }

    /**
     * The padding highlight fill color (default: transparent).
     */
    public java.util.Optional<org.openqa.selenium.devtools.dom.model.RGBA> getPaddingColor() {
        return paddingColor;
    }

    /**
     * The border highlight fill color (default: transparent).
     */
    public java.util.Optional<org.openqa.selenium.devtools.dom.model.RGBA> getBorderColor() {
        return borderColor;
    }

    /**
     * The margin highlight fill color (default: transparent).
     */
    public java.util.Optional<org.openqa.selenium.devtools.dom.model.RGBA> getMarginColor() {
        return marginColor;
    }

    /**
     * The event target element highlight fill color (default: transparent).
     */
    public java.util.Optional<org.openqa.selenium.devtools.dom.model.RGBA> getEventTargetColor() {
        return eventTargetColor;
    }

    /**
     * The shape outside fill color (default: transparent).
     */
    public java.util.Optional<org.openqa.selenium.devtools.dom.model.RGBA> getShapeColor() {
        return shapeColor;
    }

    /**
     * The shape margin fill color (default: transparent).
     */
    public java.util.Optional<org.openqa.selenium.devtools.dom.model.RGBA> getShapeMarginColor() {
        return shapeMarginColor;
    }

    /**
     * The grid layout color (default: transparent).
     */
    public java.util.Optional<org.openqa.selenium.devtools.dom.model.RGBA> getCssGridColor() {
        return cssGridColor;
    }

    /**
     * The color format used to format color styles (default: hex).
     */
    public java.util.Optional<org.openqa.selenium.devtools.overlay.model.ColorFormat> getColorFormat() {
        return colorFormat;
    }

    /**
     * The grid layout highlight configuration (default: all transparent).
     */
    public java.util.Optional<org.openqa.selenium.devtools.overlay.model.GridHighlightConfig> getGridHighlightConfig() {
        return gridHighlightConfig;
    }

    private static HighlightConfig fromJson(JsonInput input) {
        java.util.Optional<java.lang.Boolean> showInfo = java.util.Optional.empty();
        java.util.Optional<java.lang.Boolean> showStyles = java.util.Optional.empty();
        java.util.Optional<java.lang.Boolean> showRulers = java.util.Optional.empty();
        java.util.Optional<java.lang.Boolean> showExtensionLines = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.dom.model.RGBA> contentColor = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.dom.model.RGBA> paddingColor = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.dom.model.RGBA> borderColor = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.dom.model.RGBA> marginColor = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.dom.model.RGBA> eventTargetColor = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.dom.model.RGBA> shapeColor = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.dom.model.RGBA> shapeMarginColor = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.dom.model.RGBA> cssGridColor = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.overlay.model.ColorFormat> colorFormat = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.overlay.model.GridHighlightConfig> gridHighlightConfig = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "showInfo":
                    showInfo = java.util.Optional.ofNullable(input.nextBoolean());
                    break;
                case "showStyles":
                    showStyles = java.util.Optional.ofNullable(input.nextBoolean());
                    break;
                case "showRulers":
                    showRulers = java.util.Optional.ofNullable(input.nextBoolean());
                    break;
                case "showExtensionLines":
                    showExtensionLines = java.util.Optional.ofNullable(input.nextBoolean());
                    break;
                case "contentColor":
                    contentColor = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.dom.model.RGBA.class));
                    break;
                case "paddingColor":
                    paddingColor = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.dom.model.RGBA.class));
                    break;
                case "borderColor":
                    borderColor = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.dom.model.RGBA.class));
                    break;
                case "marginColor":
                    marginColor = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.dom.model.RGBA.class));
                    break;
                case "eventTargetColor":
                    eventTargetColor = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.dom.model.RGBA.class));
                    break;
                case "shapeColor":
                    shapeColor = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.dom.model.RGBA.class));
                    break;
                case "shapeMarginColor":
                    shapeMarginColor = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.dom.model.RGBA.class));
                    break;
                case "cssGridColor":
                    cssGridColor = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.dom.model.RGBA.class));
                    break;
                case "colorFormat":
                    colorFormat = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.overlay.model.ColorFormat.class));
                    break;
                case "gridHighlightConfig":
                    gridHighlightConfig = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.overlay.model.GridHighlightConfig.class));
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new HighlightConfig(showInfo, showStyles, showRulers, showExtensionLines, contentColor, paddingColor, borderColor, marginColor, eventTargetColor, shapeColor, shapeMarginColor, cssGridColor, colorFormat, gridHighlightConfig);
    }
}
