/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.webauthn.model;

import java.util.Objects;
import org.openqa.selenium.devtools.webauthn.model.AuthenticatorProtocol;
import org.openqa.selenium.devtools.webauthn.model.AuthenticatorTransport;
import org.openqa.selenium.json.JsonInput;

public class VirtualAuthenticatorOptions {
    private final AuthenticatorProtocol protocol;
    private final AuthenticatorTransport transport;
    private final Boolean hasResidentKey;
    private final Boolean hasUserVerification;
    private final Boolean automaticPresenceSimulation;

    public VirtualAuthenticatorOptions(AuthenticatorProtocol protocol, AuthenticatorTransport transport, Boolean hasResidentKey, Boolean hasUserVerification, Boolean automaticPresenceSimulation) {
        this.protocol = Objects.requireNonNull(protocol, "protocol is required");
        this.transport = Objects.requireNonNull(transport, "transport is required");
        this.hasResidentKey = Objects.requireNonNull(hasResidentKey, "hasResidentKey is required");
        this.hasUserVerification = Objects.requireNonNull(hasUserVerification, "hasUserVerification is required");
        this.automaticPresenceSimulation = automaticPresenceSimulation;
    }

    public AuthenticatorProtocol getProtocol() {
        return this.protocol;
    }

    public AuthenticatorTransport getTransport() {
        return this.transport;
    }

    public Boolean getHasResidentKey() {
        return this.hasResidentKey;
    }

    public Boolean getHasUserVerification() {
        return this.hasUserVerification;
    }

    public Boolean getAutomaticPresenceSimulation() {
        return this.automaticPresenceSimulation;
    }

    private static VirtualAuthenticatorOptions fromJson(JsonInput input) {
        AuthenticatorProtocol protocol = null;
        AuthenticatorTransport transport = null;
        Boolean hasResidentKey = null;
        Boolean hasUserVerification = null;
        Boolean automaticPresenceSimulation = null;
        input.beginObject();
        block14: while (input.hasNext()) {
            switch (input.nextName()) {
                case "protocol": {
                    protocol = (AuthenticatorProtocol)((Object)input.read(AuthenticatorProtocol.class));
                    continue block14;
                }
                case "transport": {
                    transport = (AuthenticatorTransport)((Object)input.read(AuthenticatorTransport.class));
                    continue block14;
                }
                case "hasResidentKey": {
                    hasResidentKey = input.nextBoolean();
                    continue block14;
                }
                case "hasUserVerification": {
                    hasUserVerification = input.nextBoolean();
                    continue block14;
                }
                case "automaticPresenceSimulation": {
                    automaticPresenceSimulation = input.nextBoolean();
                    continue block14;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new VirtualAuthenticatorOptions(protocol, transport, hasResidentKey, hasUserVerification, automaticPresenceSimulation);
    }
}

