/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.storage;

import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.storage.model.CacheStorageContentUpdated;
import org.openqa.selenium.devtools.storage.model.IndexedDBContentUpdated;
import org.openqa.selenium.devtools.storage.model.UsageForType;
import org.openqa.selenium.json.JsonInput;

@Beta
public class Storage {
    public static Command<Void> clearDataForOrigin(String origin, String storageTypes) {
        Objects.requireNonNull(origin, "origin is required");
        Objects.requireNonNull(storageTypes, "storageTypes is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"origin", (Object)origin);
        params.put((Object)"storageTypes", (Object)storageTypes);
        return new Command<Void>("Storage.clearDataForOrigin", (Map<String, Object>)params.build());
    }

    public static Command<GetUsageAndQuotaResponse> getUsageAndQuota(String origin) {
        Objects.requireNonNull(origin, "origin is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"origin", (Object)origin);
        return new Command<GetUsageAndQuotaResponse>("Storage.getUsageAndQuota", (Map<String, Object>)params.build(), input -> (GetUsageAndQuotaResponse)input.read(GetUsageAndQuotaResponse.class));
    }

    public static Command<Void> trackCacheStorageForOrigin(String origin) {
        Objects.requireNonNull(origin, "origin is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"origin", (Object)origin);
        return new Command<Void>("Storage.trackCacheStorageForOrigin", (Map<String, Object>)params.build());
    }

    public static Command<Void> trackIndexedDBForOrigin(String origin) {
        Objects.requireNonNull(origin, "origin is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"origin", (Object)origin);
        return new Command<Void>("Storage.trackIndexedDBForOrigin", (Map<String, Object>)params.build());
    }

    public static Command<Void> untrackCacheStorageForOrigin(String origin) {
        Objects.requireNonNull(origin, "origin is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"origin", (Object)origin);
        return new Command<Void>("Storage.untrackCacheStorageForOrigin", (Map<String, Object>)params.build());
    }

    public static Command<Void> untrackIndexedDBForOrigin(String origin) {
        Objects.requireNonNull(origin, "origin is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"origin", (Object)origin);
        return new Command<Void>("Storage.untrackIndexedDBForOrigin", (Map<String, Object>)params.build());
    }

    public static Event<CacheStorageContentUpdated> cacheStorageContentUpdated() {
        return new Event<CacheStorageContentUpdated>("Storage.cacheStorageContentUpdated", input -> (CacheStorageContentUpdated)input.read(CacheStorageContentUpdated.class));
    }

    public static Event<String> cacheStorageListUpdated() {
        return new Event<String>("Storage.cacheStorageListUpdated", ConverterFunctions.map("origin", String.class));
    }

    public static Event<IndexedDBContentUpdated> indexedDBContentUpdated() {
        return new Event<IndexedDBContentUpdated>("Storage.indexedDBContentUpdated", input -> (IndexedDBContentUpdated)input.read(IndexedDBContentUpdated.class));
    }

    public static Event<String> indexedDBListUpdated() {
        return new Event<String>("Storage.indexedDBListUpdated", ConverterFunctions.map("origin", String.class));
    }

    public static class GetUsageAndQuotaResponse {
        private final Number usage;
        private final Number quota;
        private final List<UsageForType> usageBreakdown;

        public GetUsageAndQuotaResponse(Number usage, Number quota, List<UsageForType> usageBreakdown) {
            this.usage = Objects.requireNonNull(usage, "usage is required");
            this.quota = Objects.requireNonNull(quota, "quota is required");
            this.usageBreakdown = Objects.requireNonNull(usageBreakdown, "usageBreakdown is required");
        }

        public Number getUsage() {
            return this.usage;
        }

        public Number getQuota() {
            return this.quota;
        }

        public List<UsageForType> getUsageBreakdown() {
            return this.usageBreakdown;
        }

        private static GetUsageAndQuotaResponse fromJson(JsonInput input) {
            Number usage = null;
            Number quota = null;
            List usageBreakdown = null;
            input.beginObject();
            block10: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "usage": {
                        usage = input.nextNumber();
                        continue block10;
                    }
                    case "quota": {
                        quota = input.nextNumber();
                        continue block10;
                    }
                    case "usageBreakdown": {
                        usageBreakdown = (List)input.read(new TypeToken<List<UsageForType>>(){}.getType());
                        continue block10;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new GetUsageAndQuotaResponse(usage, quota, usageBreakdown);
        }
    }
}

