/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.runtime.model;

import com.google.common.reflect.TypeToken;
import java.util.List;
import java.util.Objects;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.runtime.model.CallFrame;
import org.openqa.selenium.devtools.runtime.model.StackTraceId;
import org.openqa.selenium.json.JsonInput;

public class StackTrace {
    private final String description;
    private final List<CallFrame> callFrames;
    private final StackTrace parent;
    private final StackTraceId parentId;

    public StackTrace(String description, List<CallFrame> callFrames, StackTrace parent, StackTraceId parentId) {
        this.description = description;
        this.callFrames = Objects.requireNonNull(callFrames, "callFrames is required");
        this.parent = parent;
        this.parentId = parentId;
    }

    public String getDescription() {
        return this.description;
    }

    public List<CallFrame> getCallFrames() {
        return this.callFrames;
    }

    public StackTrace getParent() {
        return this.parent;
    }

    @Beta
    public StackTraceId getParentId() {
        return this.parentId;
    }

    private static StackTrace fromJson(JsonInput input) {
        String description = null;
        List callFrames = null;
        StackTrace parent = null;
        StackTraceId parentId = null;
        input.beginObject();
        block12: while (input.hasNext()) {
            switch (input.nextName()) {
                case "description": {
                    description = input.nextString();
                    continue block12;
                }
                case "callFrames": {
                    callFrames = (List)input.read(new TypeToken<List<CallFrame>>(){}.getType());
                    continue block12;
                }
                case "parent": {
                    parent = (StackTrace)input.read(StackTrace.class);
                    continue block12;
                }
                case "parentId": {
                    parentId = (StackTraceId)input.read(StackTraceId.class);
                    continue block12;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new StackTrace(description, callFrames, parent, parentId);
    }
}

