/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.runtime.model;

import com.google.common.reflect.TypeToken;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.devtools.runtime.model.CustomPreview;
import org.openqa.selenium.devtools.runtime.model.ObjectPreview;
import org.openqa.selenium.devtools.runtime.model.RemoteObjectId;
import org.openqa.selenium.devtools.runtime.model.UnserializableValue;
import org.openqa.selenium.json.JsonInput;

public class RemoteObject {
    private final Type type;
    private final Subtype subtype;
    private final String className;
    private final Map<String, Object> value;
    private final UnserializableValue unserializableValue;
    private final String description;
    private final RemoteObjectId objectId;
    private final ObjectPreview preview;
    private final CustomPreview customPreview;

    public RemoteObject(Type type, Subtype subtype, String className, Map<String, Object> value, UnserializableValue unserializableValue, String description, RemoteObjectId objectId, ObjectPreview preview, CustomPreview customPreview) {
        this.type = Objects.requireNonNull(type, "type is required");
        this.subtype = subtype;
        this.className = className;
        this.value = value;
        this.unserializableValue = unserializableValue;
        this.description = description;
        this.objectId = objectId;
        this.preview = preview;
        this.customPreview = customPreview;
    }

    public Type getType() {
        return this.type;
    }

    public Subtype getSubtype() {
        return this.subtype;
    }

    public String getClassName() {
        return this.className;
    }

    public Map<String, Object> getValue() {
        return this.value;
    }

    public UnserializableValue getUnserializableValue() {
        return this.unserializableValue;
    }

    public String getDescription() {
        return this.description;
    }

    public RemoteObjectId getObjectId() {
        return this.objectId;
    }

    @Beta
    public ObjectPreview getPreview() {
        return this.preview;
    }

    @Beta
    public CustomPreview getCustomPreview() {
        return this.customPreview;
    }

    private static RemoteObject fromJson(JsonInput input) {
        Type type = null;
        Subtype subtype = null;
        String className = null;
        Map value = null;
        UnserializableValue unserializableValue = null;
        String description = null;
        RemoteObjectId objectId = null;
        ObjectPreview preview = null;
        CustomPreview customPreview = null;
        input.beginObject();
        block22: while (input.hasNext()) {
            switch (input.nextName()) {
                case "type": {
                    type = Type.fromString(input.nextString());
                    continue block22;
                }
                case "subtype": {
                    subtype = Subtype.fromString(input.nextString());
                    continue block22;
                }
                case "className": {
                    className = input.nextString();
                    continue block22;
                }
                case "value": {
                    value = (Map)input.read(new TypeToken<Map<String, Object>>(){}.getType());
                    continue block22;
                }
                case "unserializableValue": {
                    unserializableValue = (UnserializableValue)input.read(UnserializableValue.class);
                    continue block22;
                }
                case "description": {
                    description = input.nextString();
                    continue block22;
                }
                case "objectId": {
                    objectId = (RemoteObjectId)input.read(RemoteObjectId.class);
                    continue block22;
                }
                case "preview": {
                    preview = (ObjectPreview)input.read(ObjectPreview.class);
                    continue block22;
                }
                case "customPreview": {
                    customPreview = (CustomPreview)input.read(CustomPreview.class);
                    continue block22;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new RemoteObject(type, subtype, className, value, unserializableValue, description, objectId, preview, customPreview);
    }

    public static enum Subtype {
        ARRAY("array"),
        NULL("null"),
        NODE("node"),
        REGEXP("regexp"),
        DATE("date"),
        MAP("map"),
        SET("set"),
        WEAKMAP("weakmap"),
        WEAKSET("weakset"),
        ITERATOR("iterator"),
        GENERATOR("generator"),
        ERROR("error"),
        PROXY("proxy"),
        PROMISE("promise"),
        TYPEDARRAY("typedarray"),
        ARRAYBUFFER("arraybuffer"),
        DATAVIEW("dataview");

        private String value;

        private Subtype(String value) {
            this.value = value;
        }

        public static Subtype fromString(String s) {
            return Arrays.stream(Subtype.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within Subtype "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static Subtype fromJson(JsonInput input) {
            return Subtype.fromString(input.nextString());
        }
    }

    public static enum Type {
        OBJECT("object"),
        FUNCTION("function"),
        UNDEFINED("undefined"),
        STRING("string"),
        NUMBER("number"),
        BOOLEAN("boolean"),
        SYMBOL("symbol"),
        BIGINT("bigint");

        private String value;

        private Type(String value) {
            this.value = value;
        }

        public static Type fromString(String s) {
            return Arrays.stream(Type.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within Type "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static Type fromJson(JsonInput input) {
            return Type.fromString(input.nextString());
        }
    }
}

