/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.runtime.model;

import java.util.Arrays;
import java.util.Objects;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.devtools.runtime.model.ObjectPreview;
import org.openqa.selenium.json.JsonInput;

@Beta
public class PropertyPreview {
    private final String name;
    private final Type type;
    private final String value;
    private final ObjectPreview valuePreview;
    private final Subtype subtype;

    public PropertyPreview(String name, Type type, String value, ObjectPreview valuePreview, Subtype subtype) {
        this.name = Objects.requireNonNull(name, "name is required");
        this.type = Objects.requireNonNull(type, "type is required");
        this.value = value;
        this.valuePreview = valuePreview;
        this.subtype = subtype;
    }

    public String getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    public ObjectPreview getValuePreview() {
        return this.valuePreview;
    }

    public Subtype getSubtype() {
        return this.subtype;
    }

    private static PropertyPreview fromJson(JsonInput input) {
        String name = null;
        Type type = null;
        String value = null;
        ObjectPreview valuePreview = null;
        Subtype subtype = null;
        input.beginObject();
        block14: while (input.hasNext()) {
            switch (input.nextName()) {
                case "name": {
                    name = input.nextString();
                    continue block14;
                }
                case "type": {
                    type = Type.fromString(input.nextString());
                    continue block14;
                }
                case "value": {
                    value = input.nextString();
                    continue block14;
                }
                case "valuePreview": {
                    valuePreview = (ObjectPreview)input.read(ObjectPreview.class);
                    continue block14;
                }
                case "subtype": {
                    subtype = Subtype.fromString(input.nextString());
                    continue block14;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new PropertyPreview(name, type, value, valuePreview, subtype);
    }

    public static enum Subtype {
        ARRAY("array"),
        NULL("null"),
        NODE("node"),
        REGEXP("regexp"),
        DATE("date"),
        MAP("map"),
        SET("set"),
        WEAKMAP("weakmap"),
        WEAKSET("weakset"),
        ITERATOR("iterator"),
        GENERATOR("generator"),
        ERROR("error");

        private String value;

        private Subtype(String value) {
            this.value = value;
        }

        public static Subtype fromString(String s) {
            return Arrays.stream(Subtype.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within Subtype "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static Subtype fromJson(JsonInput input) {
            return Subtype.fromString(input.nextString());
        }
    }

    public static enum Type {
        OBJECT("object"),
        FUNCTION("function"),
        UNDEFINED("undefined"),
        STRING("string"),
        NUMBER("number"),
        BOOLEAN("boolean"),
        SYMBOL("symbol"),
        ACCESSOR("accessor"),
        BIGINT("bigint");

        private String value;

        private Type(String value) {
            this.value = value;
        }

        public static Type fromString(String s) {
            return Arrays.stream(Type.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within Type "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static Type fromJson(JsonInput input) {
            return Type.fromString(input.nextString());
        }
    }
}

