/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.runtime.model;

import java.util.Objects;
import org.openqa.selenium.devtools.runtime.model.RemoteObject;
import org.openqa.selenium.json.JsonInput;

public class PropertyDescriptor {
    private final String name;
    private final RemoteObject value;
    private final Boolean writable;
    private final RemoteObject get;
    private final RemoteObject set;
    private final Boolean configurable;
    private final Boolean enumerable;
    private final Boolean wasThrown;
    private final Boolean isOwn;
    private final RemoteObject symbol;

    public PropertyDescriptor(String name, RemoteObject value, Boolean writable, RemoteObject get, RemoteObject set, Boolean configurable, Boolean enumerable, Boolean wasThrown, Boolean isOwn, RemoteObject symbol) {
        this.name = Objects.requireNonNull(name, "name is required");
        this.value = value;
        this.writable = writable;
        this.get = get;
        this.set = set;
        this.configurable = Objects.requireNonNull(configurable, "configurable is required");
        this.enumerable = Objects.requireNonNull(enumerable, "enumerable is required");
        this.wasThrown = wasThrown;
        this.isOwn = isOwn;
        this.symbol = symbol;
    }

    public String getName() {
        return this.name;
    }

    public RemoteObject getValue() {
        return this.value;
    }

    public Boolean getWritable() {
        return this.writable;
    }

    public RemoteObject getGet() {
        return this.get;
    }

    public RemoteObject getSet() {
        return this.set;
    }

    public Boolean getConfigurable() {
        return this.configurable;
    }

    public Boolean getEnumerable() {
        return this.enumerable;
    }

    public Boolean getWasThrown() {
        return this.wasThrown;
    }

    public Boolean getIsOwn() {
        return this.isOwn;
    }

    public RemoteObject getSymbol() {
        return this.symbol;
    }

    private static PropertyDescriptor fromJson(JsonInput input) {
        String name = null;
        RemoteObject value = null;
        Boolean writable = null;
        RemoteObject get = null;
        RemoteObject set = null;
        Boolean configurable = null;
        Boolean enumerable = null;
        Boolean wasThrown = null;
        Boolean isOwn = null;
        RemoteObject symbol = null;
        input.beginObject();
        block24: while (input.hasNext()) {
            switch (input.nextName()) {
                case "name": {
                    name = input.nextString();
                    continue block24;
                }
                case "value": {
                    value = (RemoteObject)input.read(RemoteObject.class);
                    continue block24;
                }
                case "writable": {
                    writable = input.nextBoolean();
                    continue block24;
                }
                case "get": {
                    get = (RemoteObject)input.read(RemoteObject.class);
                    continue block24;
                }
                case "set": {
                    set = (RemoteObject)input.read(RemoteObject.class);
                    continue block24;
                }
                case "configurable": {
                    configurable = input.nextBoolean();
                    continue block24;
                }
                case "enumerable": {
                    enumerable = input.nextBoolean();
                    continue block24;
                }
                case "wasThrown": {
                    wasThrown = input.nextBoolean();
                    continue block24;
                }
                case "isOwn": {
                    isOwn = input.nextBoolean();
                    continue block24;
                }
                case "symbol": {
                    symbol = (RemoteObject)input.read(RemoteObject.class);
                    continue block24;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new PropertyDescriptor(name, value, writable, get, set, configurable, enumerable, wasThrown, isOwn, symbol);
    }
}

