/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.runtime.model;

import com.google.common.reflect.TypeToken;
import java.util.Map;
import org.openqa.selenium.devtools.runtime.model.RemoteObjectId;
import org.openqa.selenium.devtools.runtime.model.UnserializableValue;
import org.openqa.selenium.json.JsonInput;

public class CallArgument {
    private final Map<String, Object> value;
    private final UnserializableValue unserializableValue;
    private final RemoteObjectId objectId;

    public CallArgument(Map<String, Object> value, UnserializableValue unserializableValue, RemoteObjectId objectId) {
        this.value = value;
        this.unserializableValue = unserializableValue;
        this.objectId = objectId;
    }

    public Map<String, Object> getValue() {
        return this.value;
    }

    public UnserializableValue getUnserializableValue() {
        return this.unserializableValue;
    }

    public RemoteObjectId getObjectId() {
        return this.objectId;
    }

    private static CallArgument fromJson(JsonInput input) {
        Map value = null;
        UnserializableValue unserializableValue = null;
        RemoteObjectId objectId = null;
        input.beginObject();
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "value": {
                    value = (Map)input.read(new TypeToken<Map<String, Object>>(){}.getType());
                    continue block10;
                }
                case "unserializableValue": {
                    unserializableValue = (UnserializableValue)input.read(UnserializableValue.class);
                    continue block10;
                }
                case "objectId": {
                    objectId = (RemoteObjectId)input.read(RemoteObjectId.class);
                    continue block10;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new CallArgument(value, unserializableValue, objectId);
    }
}

