/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.runtime;

import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.runtime.model.BindingCalled;
import org.openqa.selenium.devtools.runtime.model.CallArgument;
import org.openqa.selenium.devtools.runtime.model.ConsoleAPICalled;
import org.openqa.selenium.devtools.runtime.model.ExceptionDetails;
import org.openqa.selenium.devtools.runtime.model.ExceptionRevoked;
import org.openqa.selenium.devtools.runtime.model.ExceptionThrown;
import org.openqa.selenium.devtools.runtime.model.ExecutionContextDescription;
import org.openqa.selenium.devtools.runtime.model.ExecutionContextId;
import org.openqa.selenium.devtools.runtime.model.InspectRequested;
import org.openqa.selenium.devtools.runtime.model.InternalPropertyDescriptor;
import org.openqa.selenium.devtools.runtime.model.PrivatePropertyDescriptor;
import org.openqa.selenium.devtools.runtime.model.PropertyDescriptor;
import org.openqa.selenium.devtools.runtime.model.RemoteObject;
import org.openqa.selenium.devtools.runtime.model.RemoteObjectId;
import org.openqa.selenium.devtools.runtime.model.ScriptId;
import org.openqa.selenium.devtools.runtime.model.TimeDelta;
import org.openqa.selenium.json.JsonInput;

public class Runtime {
    public static Command<AwaitPromiseResponse> awaitPromise(RemoteObjectId promiseObjectId, Optional<Boolean> returnByValue, Optional<Boolean> generatePreview) {
        Objects.requireNonNull(promiseObjectId, "promiseObjectId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"promiseObjectId", (Object)promiseObjectId);
        returnByValue.ifPresent(p -> params.put((Object)"returnByValue", p));
        generatePreview.ifPresent(p -> params.put((Object)"generatePreview", p));
        return new Command<AwaitPromiseResponse>("Runtime.awaitPromise", (Map<String, Object>)params.build(), input -> (AwaitPromiseResponse)input.read(AwaitPromiseResponse.class));
    }

    public static Command<CallFunctionOnResponse> callFunctionOn(String functionDeclaration, Optional<RemoteObjectId> objectId, Optional<List<CallArgument>> arguments, Optional<Boolean> silent, Optional<Boolean> returnByValue, Optional<Boolean> generatePreview, Optional<Boolean> userGesture, Optional<Boolean> awaitPromise, Optional<ExecutionContextId> executionContextId, Optional<String> objectGroup) {
        Objects.requireNonNull(functionDeclaration, "functionDeclaration is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"functionDeclaration", (Object)functionDeclaration);
        objectId.ifPresent(p -> params.put((Object)"objectId", p));
        arguments.ifPresent(p -> params.put((Object)"arguments", p));
        silent.ifPresent(p -> params.put((Object)"silent", p));
        returnByValue.ifPresent(p -> params.put((Object)"returnByValue", p));
        generatePreview.ifPresent(p -> params.put((Object)"generatePreview", p));
        userGesture.ifPresent(p -> params.put((Object)"userGesture", p));
        awaitPromise.ifPresent(p -> params.put((Object)"awaitPromise", p));
        executionContextId.ifPresent(p -> params.put((Object)"executionContextId", p));
        objectGroup.ifPresent(p -> params.put((Object)"objectGroup", p));
        return new Command<CallFunctionOnResponse>("Runtime.callFunctionOn", (Map<String, Object>)params.build(), input -> (CallFunctionOnResponse)input.read(CallFunctionOnResponse.class));
    }

    public static Command<CompileScriptResponse> compileScript(String expression, String sourceURL, Boolean persistScript, Optional<ExecutionContextId> executionContextId) {
        Objects.requireNonNull(expression, "expression is required");
        Objects.requireNonNull(sourceURL, "sourceURL is required");
        Objects.requireNonNull(persistScript, "persistScript is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"expression", (Object)expression);
        params.put((Object)"sourceURL", (Object)sourceURL);
        params.put((Object)"persistScript", (Object)persistScript);
        executionContextId.ifPresent(p -> params.put((Object)"executionContextId", p));
        return new Command<CompileScriptResponse>("Runtime.compileScript", (Map<String, Object>)params.build(), input -> (CompileScriptResponse)input.read(CompileScriptResponse.class));
    }

    public static Command<Void> disable() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("Runtime.disable", (Map<String, Object>)params.build());
    }

    public static Command<Void> discardConsoleEntries() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("Runtime.discardConsoleEntries", (Map<String, Object>)params.build());
    }

    public static Command<Void> enable() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("Runtime.enable", (Map<String, Object>)params.build());
    }

    public static Command<EvaluateResponse> evaluate(String expression, Optional<String> objectGroup, Optional<Boolean> includeCommandLineAPI, Optional<Boolean> silent, Optional<ExecutionContextId> contextId, Optional<Boolean> returnByValue, Optional<Boolean> generatePreview, Optional<Boolean> userGesture, Optional<Boolean> awaitPromise, Optional<Boolean> throwOnSideEffect, Optional<TimeDelta> timeout) {
        Objects.requireNonNull(expression, "expression is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"expression", (Object)expression);
        objectGroup.ifPresent(p -> params.put((Object)"objectGroup", p));
        includeCommandLineAPI.ifPresent(p -> params.put((Object)"includeCommandLineAPI", p));
        silent.ifPresent(p -> params.put((Object)"silent", p));
        contextId.ifPresent(p -> params.put((Object)"contextId", p));
        returnByValue.ifPresent(p -> params.put((Object)"returnByValue", p));
        generatePreview.ifPresent(p -> params.put((Object)"generatePreview", p));
        userGesture.ifPresent(p -> params.put((Object)"userGesture", p));
        awaitPromise.ifPresent(p -> params.put((Object)"awaitPromise", p));
        throwOnSideEffect.ifPresent(p -> params.put((Object)"throwOnSideEffect", p));
        timeout.ifPresent(p -> params.put((Object)"timeout", p));
        return new Command<EvaluateResponse>("Runtime.evaluate", (Map<String, Object>)params.build(), input -> (EvaluateResponse)input.read(EvaluateResponse.class));
    }

    @Beta
    public static Command<String> getIsolateId() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<String>("Runtime.getIsolateId", (Map<String, Object>)params.build(), ConverterFunctions.map("id", String.class));
    }

    @Beta
    public static Command<GetHeapUsageResponse> getHeapUsage() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<GetHeapUsageResponse>("Runtime.getHeapUsage", (Map<String, Object>)params.build(), input -> (GetHeapUsageResponse)input.read(GetHeapUsageResponse.class));
    }

    public static Command<GetPropertiesResponse> getProperties(RemoteObjectId objectId, Optional<Boolean> ownProperties, Optional<Boolean> accessorPropertiesOnly, Optional<Boolean> generatePreview) {
        Objects.requireNonNull(objectId, "objectId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"objectId", (Object)objectId);
        ownProperties.ifPresent(p -> params.put((Object)"ownProperties", p));
        accessorPropertiesOnly.ifPresent(p -> params.put((Object)"accessorPropertiesOnly", p));
        generatePreview.ifPresent(p -> params.put((Object)"generatePreview", p));
        return new Command<GetPropertiesResponse>("Runtime.getProperties", (Map<String, Object>)params.build(), input -> (GetPropertiesResponse)input.read(GetPropertiesResponse.class));
    }

    public static Command<List<String>> globalLexicalScopeNames(Optional<ExecutionContextId> executionContextId) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        executionContextId.ifPresent(p -> params.put((Object)"executionContextId", p));
        return new Command<List<String>>("Runtime.globalLexicalScopeNames", (Map<String, Object>)params.build(), ConverterFunctions.map("names", new TypeToken<List<String>>(){}.getType()));
    }

    public static Command<RemoteObject> queryObjects(RemoteObjectId prototypeObjectId, Optional<String> objectGroup) {
        Objects.requireNonNull(prototypeObjectId, "prototypeObjectId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"prototypeObjectId", (Object)prototypeObjectId);
        objectGroup.ifPresent(p -> params.put((Object)"objectGroup", p));
        return new Command<RemoteObject>("Runtime.queryObjects", (Map<String, Object>)params.build(), ConverterFunctions.map("objects", RemoteObject.class));
    }

    public static Command<Void> releaseObject(RemoteObjectId objectId) {
        Objects.requireNonNull(objectId, "objectId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"objectId", (Object)objectId);
        return new Command<Void>("Runtime.releaseObject", (Map<String, Object>)params.build());
    }

    public static Command<Void> releaseObjectGroup(String objectGroup) {
        Objects.requireNonNull(objectGroup, "objectGroup is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"objectGroup", (Object)objectGroup);
        return new Command<Void>("Runtime.releaseObjectGroup", (Map<String, Object>)params.build());
    }

    public static Command<Void> runIfWaitingForDebugger() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("Runtime.runIfWaitingForDebugger", (Map<String, Object>)params.build());
    }

    public static Command<RunScriptResponse> runScript(ScriptId scriptId, Optional<ExecutionContextId> executionContextId, Optional<String> objectGroup, Optional<Boolean> silent, Optional<Boolean> includeCommandLineAPI, Optional<Boolean> returnByValue, Optional<Boolean> generatePreview, Optional<Boolean> awaitPromise) {
        Objects.requireNonNull(scriptId, "scriptId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"scriptId", (Object)scriptId);
        executionContextId.ifPresent(p -> params.put((Object)"executionContextId", p));
        objectGroup.ifPresent(p -> params.put((Object)"objectGroup", p));
        silent.ifPresent(p -> params.put((Object)"silent", p));
        includeCommandLineAPI.ifPresent(p -> params.put((Object)"includeCommandLineAPI", p));
        returnByValue.ifPresent(p -> params.put((Object)"returnByValue", p));
        generatePreview.ifPresent(p -> params.put((Object)"generatePreview", p));
        awaitPromise.ifPresent(p -> params.put((Object)"awaitPromise", p));
        return new Command<RunScriptResponse>("Runtime.runScript", (Map<String, Object>)params.build(), input -> (RunScriptResponse)input.read(RunScriptResponse.class));
    }

    public static Command<Void> setAsyncCallStackDepth(Integer maxDepth) {
        Objects.requireNonNull(maxDepth, "maxDepth is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"maxDepth", (Object)maxDepth);
        return new Command<Void>("Runtime.setAsyncCallStackDepth", (Map<String, Object>)params.build());
    }

    @Beta
    public static Command<Void> setCustomObjectFormatterEnabled(Boolean enabled) {
        Objects.requireNonNull(enabled, "enabled is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"enabled", (Object)enabled);
        return new Command<Void>("Runtime.setCustomObjectFormatterEnabled", (Map<String, Object>)params.build());
    }

    @Beta
    public static Command<Void> setMaxCallStackSizeToCapture(Integer size) {
        Objects.requireNonNull(size, "size is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"size", (Object)size);
        return new Command<Void>("Runtime.setMaxCallStackSizeToCapture", (Map<String, Object>)params.build());
    }

    @Beta
    public static Command<Void> terminateExecution() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("Runtime.terminateExecution", (Map<String, Object>)params.build());
    }

    @Beta
    public static Command<Void> addBinding(String name, Optional<ExecutionContextId> executionContextId) {
        Objects.requireNonNull(name, "name is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"name", (Object)name);
        executionContextId.ifPresent(p -> params.put((Object)"executionContextId", p));
        return new Command<Void>("Runtime.addBinding", (Map<String, Object>)params.build());
    }

    @Beta
    public static Command<Void> removeBinding(String name) {
        Objects.requireNonNull(name, "name is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"name", (Object)name);
        return new Command<Void>("Runtime.removeBinding", (Map<String, Object>)params.build());
    }

    public static Event<BindingCalled> bindingCalled() {
        return new Event<BindingCalled>("Runtime.bindingCalled", input -> (BindingCalled)input.read(BindingCalled.class));
    }

    public static Event<ConsoleAPICalled> consoleAPICalled() {
        return new Event<ConsoleAPICalled>("Runtime.consoleAPICalled", input -> (ConsoleAPICalled)input.read(ConsoleAPICalled.class));
    }

    public static Event<ExceptionRevoked> exceptionRevoked() {
        return new Event<ExceptionRevoked>("Runtime.exceptionRevoked", input -> (ExceptionRevoked)input.read(ExceptionRevoked.class));
    }

    public static Event<ExceptionThrown> exceptionThrown() {
        return new Event<ExceptionThrown>("Runtime.exceptionThrown", input -> (ExceptionThrown)input.read(ExceptionThrown.class));
    }

    public static Event<ExecutionContextDescription> executionContextCreated() {
        return new Event<ExecutionContextDescription>("Runtime.executionContextCreated", ConverterFunctions.map("context", ExecutionContextDescription.class));
    }

    public static Event<ExecutionContextId> executionContextDestroyed() {
        return new Event<ExecutionContextId>("Runtime.executionContextDestroyed", ConverterFunctions.map("executionContextId", ExecutionContextId.class));
    }

    public static Event<Void> executionContextsCleared() {
        return new Event<Void>("Runtime.executionContextsCleared", input -> null);
    }

    public static Event<InspectRequested> inspectRequested() {
        return new Event<InspectRequested>("Runtime.inspectRequested", input -> (InspectRequested)input.read(InspectRequested.class));
    }

    public static class RunScriptResponse {
        private final RemoteObject result;
        private final ExceptionDetails exceptionDetails;

        public RunScriptResponse(RemoteObject result, ExceptionDetails exceptionDetails) {
            this.result = Objects.requireNonNull(result, "result is required");
            this.exceptionDetails = Objects.requireNonNull(exceptionDetails, "exceptionDetails is required");
        }

        public RemoteObject getResult() {
            return this.result;
        }

        public ExceptionDetails getExceptionDetails() {
            return this.exceptionDetails;
        }

        private static RunScriptResponse fromJson(JsonInput input) {
            RemoteObject result = null;
            ExceptionDetails exceptionDetails = null;
            input.beginObject();
            block8: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "result": {
                        result = (RemoteObject)input.read(RemoteObject.class);
                        continue block8;
                    }
                    case "exceptionDetails": {
                        exceptionDetails = (ExceptionDetails)input.read(ExceptionDetails.class);
                        continue block8;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new RunScriptResponse(result, exceptionDetails);
        }
    }

    public static class GetPropertiesResponse {
        private final List<PropertyDescriptor> result;
        private final List<InternalPropertyDescriptor> internalProperties;
        private final List<PrivatePropertyDescriptor> privateProperties;
        private final ExceptionDetails exceptionDetails;

        public GetPropertiesResponse(List<PropertyDescriptor> result, List<InternalPropertyDescriptor> internalProperties, List<PrivatePropertyDescriptor> privateProperties, ExceptionDetails exceptionDetails) {
            this.result = Objects.requireNonNull(result, "result is required");
            this.internalProperties = Objects.requireNonNull(internalProperties, "internalProperties is required");
            this.privateProperties = Objects.requireNonNull(privateProperties, "privateProperties is required");
            this.exceptionDetails = Objects.requireNonNull(exceptionDetails, "exceptionDetails is required");
        }

        public List<PropertyDescriptor> getResult() {
            return this.result;
        }

        public List<InternalPropertyDescriptor> getInternalProperties() {
            return this.internalProperties;
        }

        public List<PrivatePropertyDescriptor> getPrivateProperties() {
            return this.privateProperties;
        }

        public ExceptionDetails getExceptionDetails() {
            return this.exceptionDetails;
        }

        private static GetPropertiesResponse fromJson(JsonInput input) {
            List result = null;
            List internalProperties = null;
            List privateProperties = null;
            ExceptionDetails exceptionDetails = null;
            input.beginObject();
            block12: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "result": {
                        result = (List)input.read(new TypeToken<List<PropertyDescriptor>>(){}.getType());
                        continue block12;
                    }
                    case "internalProperties": {
                        internalProperties = (List)input.read(new TypeToken<List<InternalPropertyDescriptor>>(){}.getType());
                        continue block12;
                    }
                    case "privateProperties": {
                        privateProperties = (List)input.read(new TypeToken<List<PrivatePropertyDescriptor>>(){}.getType());
                        continue block12;
                    }
                    case "exceptionDetails": {
                        exceptionDetails = (ExceptionDetails)input.read(ExceptionDetails.class);
                        continue block12;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new GetPropertiesResponse(result, internalProperties, privateProperties, exceptionDetails);
        }
    }

    public static class GetHeapUsageResponse {
        private final Number usedSize;
        private final Number totalSize;

        public GetHeapUsageResponse(Number usedSize, Number totalSize) {
            this.usedSize = Objects.requireNonNull(usedSize, "usedSize is required");
            this.totalSize = Objects.requireNonNull(totalSize, "totalSize is required");
        }

        public Number getUsedSize() {
            return this.usedSize;
        }

        public Number getTotalSize() {
            return this.totalSize;
        }

        private static GetHeapUsageResponse fromJson(JsonInput input) {
            Number usedSize = null;
            Number totalSize = null;
            input.beginObject();
            block8: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "usedSize": {
                        usedSize = input.nextNumber();
                        continue block8;
                    }
                    case "totalSize": {
                        totalSize = input.nextNumber();
                        continue block8;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new GetHeapUsageResponse(usedSize, totalSize);
        }
    }

    public static class EvaluateResponse {
        private final RemoteObject result;
        private final ExceptionDetails exceptionDetails;

        public EvaluateResponse(RemoteObject result, ExceptionDetails exceptionDetails) {
            this.result = Objects.requireNonNull(result, "result is required");
            this.exceptionDetails = Objects.requireNonNull(exceptionDetails, "exceptionDetails is required");
        }

        public RemoteObject getResult() {
            return this.result;
        }

        public ExceptionDetails getExceptionDetails() {
            return this.exceptionDetails;
        }

        private static EvaluateResponse fromJson(JsonInput input) {
            RemoteObject result = null;
            ExceptionDetails exceptionDetails = null;
            input.beginObject();
            block8: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "result": {
                        result = (RemoteObject)input.read(RemoteObject.class);
                        continue block8;
                    }
                    case "exceptionDetails": {
                        exceptionDetails = (ExceptionDetails)input.read(ExceptionDetails.class);
                        continue block8;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new EvaluateResponse(result, exceptionDetails);
        }
    }

    public static class CompileScriptResponse {
        private final ScriptId scriptId;
        private final ExceptionDetails exceptionDetails;

        public CompileScriptResponse(ScriptId scriptId, ExceptionDetails exceptionDetails) {
            this.scriptId = Objects.requireNonNull(scriptId, "scriptId is required");
            this.exceptionDetails = Objects.requireNonNull(exceptionDetails, "exceptionDetails is required");
        }

        public ScriptId getScriptId() {
            return this.scriptId;
        }

        public ExceptionDetails getExceptionDetails() {
            return this.exceptionDetails;
        }

        private static CompileScriptResponse fromJson(JsonInput input) {
            ScriptId scriptId = null;
            ExceptionDetails exceptionDetails = null;
            input.beginObject();
            block8: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "scriptId": {
                        scriptId = (ScriptId)input.read(ScriptId.class);
                        continue block8;
                    }
                    case "exceptionDetails": {
                        exceptionDetails = (ExceptionDetails)input.read(ExceptionDetails.class);
                        continue block8;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new CompileScriptResponse(scriptId, exceptionDetails);
        }
    }

    public static class CallFunctionOnResponse {
        private final RemoteObject result;
        private final ExceptionDetails exceptionDetails;

        public CallFunctionOnResponse(RemoteObject result, ExceptionDetails exceptionDetails) {
            this.result = Objects.requireNonNull(result, "result is required");
            this.exceptionDetails = Objects.requireNonNull(exceptionDetails, "exceptionDetails is required");
        }

        public RemoteObject getResult() {
            return this.result;
        }

        public ExceptionDetails getExceptionDetails() {
            return this.exceptionDetails;
        }

        private static CallFunctionOnResponse fromJson(JsonInput input) {
            RemoteObject result = null;
            ExceptionDetails exceptionDetails = null;
            input.beginObject();
            block8: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "result": {
                        result = (RemoteObject)input.read(RemoteObject.class);
                        continue block8;
                    }
                    case "exceptionDetails": {
                        exceptionDetails = (ExceptionDetails)input.read(ExceptionDetails.class);
                        continue block8;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new CallFunctionOnResponse(result, exceptionDetails);
        }
    }

    public static class AwaitPromiseResponse {
        private final RemoteObject result;
        private final ExceptionDetails exceptionDetails;

        public AwaitPromiseResponse(RemoteObject result, ExceptionDetails exceptionDetails) {
            this.result = Objects.requireNonNull(result, "result is required");
            this.exceptionDetails = Objects.requireNonNull(exceptionDetails, "exceptionDetails is required");
        }

        public RemoteObject getResult() {
            return this.result;
        }

        public ExceptionDetails getExceptionDetails() {
            return this.exceptionDetails;
        }

        private static AwaitPromiseResponse fromJson(JsonInput input) {
            RemoteObject result = null;
            ExceptionDetails exceptionDetails = null;
            input.beginObject();
            block8: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "result": {
                        result = (RemoteObject)input.read(RemoteObject.class);
                        continue block8;
                    }
                    case "exceptionDetails": {
                        exceptionDetails = (ExceptionDetails)input.read(ExceptionDetails.class);
                        continue block8;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new AwaitPromiseResponse(result, exceptionDetails);
        }
    }
}

