/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.profiler;

import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.profiler.model.ConsoleProfileFinished;
import org.openqa.selenium.devtools.profiler.model.ConsoleProfileStarted;
import org.openqa.selenium.devtools.profiler.model.Profile;
import org.openqa.selenium.devtools.profiler.model.ScriptCoverage;
import org.openqa.selenium.devtools.profiler.model.ScriptTypeProfile;

public class Profiler {
    public static Command<Void> disable() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("Profiler.disable", (Map<String, Object>)params.build());
    }

    public static Command<Void> enable() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("Profiler.enable", (Map<String, Object>)params.build());
    }

    public static Command<List<ScriptCoverage>> getBestEffortCoverage() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<List<ScriptCoverage>>("Profiler.getBestEffortCoverage", (Map<String, Object>)params.build(), ConverterFunctions.map("result", new TypeToken<List<ScriptCoverage>>(){}.getType()));
    }

    public static Command<Void> setSamplingInterval(Integer interval) {
        Objects.requireNonNull(interval, "interval is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"interval", (Object)interval);
        return new Command<Void>("Profiler.setSamplingInterval", (Map<String, Object>)params.build());
    }

    public static Command<Void> start() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("Profiler.start", (Map<String, Object>)params.build());
    }

    public static Command<Void> startPreciseCoverage(Optional<Boolean> callCount, Optional<Boolean> detailed) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        callCount.ifPresent(p -> params.put((Object)"callCount", p));
        detailed.ifPresent(p -> params.put((Object)"detailed", p));
        return new Command<Void>("Profiler.startPreciseCoverage", (Map<String, Object>)params.build());
    }

    @Beta
    public static Command<Void> startTypeProfile() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("Profiler.startTypeProfile", (Map<String, Object>)params.build());
    }

    public static Command<Profile> stop() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Profile>("Profiler.stop", (Map<String, Object>)params.build(), ConverterFunctions.map("profile", Profile.class));
    }

    public static Command<Void> stopPreciseCoverage() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("Profiler.stopPreciseCoverage", (Map<String, Object>)params.build());
    }

    @Beta
    public static Command<Void> stopTypeProfile() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("Profiler.stopTypeProfile", (Map<String, Object>)params.build());
    }

    public static Command<List<ScriptCoverage>> takePreciseCoverage() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<List<ScriptCoverage>>("Profiler.takePreciseCoverage", (Map<String, Object>)params.build(), ConverterFunctions.map("result", new TypeToken<List<ScriptCoverage>>(){}.getType()));
    }

    @Beta
    public static Command<List<ScriptTypeProfile>> takeTypeProfile() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<List<ScriptTypeProfile>>("Profiler.takeTypeProfile", (Map<String, Object>)params.build(), ConverterFunctions.map("result", new TypeToken<List<ScriptTypeProfile>>(){}.getType()));
    }

    public static Event<ConsoleProfileFinished> consoleProfileFinished() {
        return new Event<ConsoleProfileFinished>("Profiler.consoleProfileFinished", input -> (ConsoleProfileFinished)input.read(ConsoleProfileFinished.class));
    }

    public static Event<ConsoleProfileStarted> consoleProfileStarted() {
        return new Event<ConsoleProfileStarted>("Profiler.consoleProfileStarted", input -> (ConsoleProfileStarted)input.read(ConsoleProfileStarted.class));
    }
}

