/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.page.model;

import com.google.common.reflect.TypeToken;
import java.util.List;
import java.util.Objects;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.page.model.Frame;
import org.openqa.selenium.devtools.page.model.FrameResource;
import org.openqa.selenium.json.JsonInput;

@Beta
public class FrameResourceTree {
    private final Frame frame;
    private final List<FrameResourceTree> childFrames;
    private final List<FrameResource> resources;

    public FrameResourceTree(Frame frame, List<FrameResourceTree> childFrames, List<FrameResource> resources) {
        this.frame = Objects.requireNonNull(frame, "frame is required");
        this.childFrames = childFrames;
        this.resources = Objects.requireNonNull(resources, "resources is required");
    }

    public Frame getFrame() {
        return this.frame;
    }

    public List<FrameResourceTree> getChildFrames() {
        return this.childFrames;
    }

    public List<FrameResource> getResources() {
        return this.resources;
    }

    private static FrameResourceTree fromJson(JsonInput input) {
        Frame frame = null;
        List childFrames = null;
        List resources = null;
        input.beginObject();
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "frame": {
                    frame = (Frame)input.read(Frame.class);
                    continue block10;
                }
                case "childFrames": {
                    childFrames = (List)input.read(new TypeToken<List<FrameResourceTree>>(){}.getType());
                    continue block10;
                }
                case "resources": {
                    resources = (List)input.read(new TypeToken<List<FrameResource>>(){}.getType());
                    continue block10;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new FrameResourceTree(frame, childFrames, resources);
    }
}

