/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.page.model;

import java.util.Objects;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.page.model.ClientNavigationReason;
import org.openqa.selenium.devtools.page.model.FrameId;
import org.openqa.selenium.json.JsonInput;

@Beta
public class FrameRequestedNavigation {
    private final FrameId frameId;
    private final ClientNavigationReason reason;
    private final String url;

    public FrameRequestedNavigation(FrameId frameId, ClientNavigationReason reason, String url) {
        this.frameId = Objects.requireNonNull(frameId, "frameId is required");
        this.reason = Objects.requireNonNull(reason, "reason is required");
        this.url = Objects.requireNonNull(url, "url is required");
    }

    public FrameId getFrameId() {
        return this.frameId;
    }

    public ClientNavigationReason getReason() {
        return this.reason;
    }

    public String getUrl() {
        return this.url;
    }

    private static FrameRequestedNavigation fromJson(JsonInput input) {
        FrameId frameId = null;
        ClientNavigationReason reason = null;
        String url = null;
        input.beginObject();
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "frameId": {
                    frameId = (FrameId)input.read(FrameId.class);
                    continue block10;
                }
                case "reason": {
                    reason = (ClientNavigationReason)((Object)input.read(ClientNavigationReason.class));
                    continue block10;
                }
                case "url": {
                    url = input.nextString();
                    continue block10;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new FrameRequestedNavigation(frameId, reason, url);
    }
}

